/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.saml;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.error.jwt.InvalidJwtException;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.idsite.AccountResult;
import com.stormpath.sdk.idsite.AuthenticationResult;
import com.stormpath.sdk.idsite.LogoutResult;
import com.stormpath.sdk.idsite.NonceStore;
import com.stormpath.sdk.impl.account.DefaultAccountResult;
import com.stormpath.sdk.impl.account.DefaultAuthenticationResult;
import com.stormpath.sdk.impl.account.DefaultLogoutResult;
import com.stormpath.sdk.impl.authc.HttpServletRequestWrapper;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.error.DefaultError;
import com.stormpath.sdk.impl.idsite.DefaultNonceStore;
import com.stormpath.sdk.impl.jwt.JwtSignatureValidator;
import com.stormpath.sdk.impl.jwt.JwtWrapper;
import com.stormpath.sdk.impl.saml.SamlResultStatus;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.saml.SamlCallbackHandler;
import com.stormpath.sdk.saml.SamlResultListener;
import com.stormpath.sdk.saml.SamlRuntimeException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultSamlCallbackHandler
implements SamlCallbackHandler {
    private static final String HTTP_SERVLET_REQUEST_FQCN = "javax.servlet.http.HttpServletRequest";
    private static final String HTTP_SERVLET_REQUEST_WRAPPER_FQCN = "com.stormpath.sdk.impl.authc.DefaultHttpServletRequestWrapper";
    private static final Class<? extends HttpServletRequestWrapper> HTTP_SERVLET_REQUEST_WRAPPER_CLASS = Classes.isAvailable((String)"javax.servlet.http.HttpServletRequest") ? Classes.forName((String)"com.stormpath.sdk.impl.authc.DefaultHttpServletRequestWrapper") : null;
    private final InternalDataStore dataStore;
    private final Application application;
    private final String jwtResponse;
    private NonceStore nonceStore;
    private List<SamlResultListener> resultListeners = new ArrayList<SamlResultListener>();

    public DefaultSamlCallbackHandler(InternalDataStore dataStore, Application application, Object httpRequest) {
        Assert.notNull((Object)dataStore, (String)"datastore cannot be null or empty.");
        Assert.notNull((Object)application, (String)"application cannot be null.");
        Assert.notNull((Object)httpRequest, (String)"httpRequest cannot be null.");
        this.dataStore = dataStore;
        this.application = application;
        this.jwtResponse = this.getJwtResponse(httpRequest);
        this.nonceStore = new DefaultNonceStore(dataStore.getCacheResolver());
    }

    public SamlCallbackHandler setNonceStore(NonceStore nonceStore) {
        Assert.notNull((Object)nonceStore);
        this.nonceStore = nonceStore;
        return this;
    }

    public AccountResult getAccountResult() {
        JwtWrapper jwtWrapper = new JwtWrapper(this.jwtResponse);
        Map jsonPayload = jwtWrapper.getJsonPayloadAsMap();
        Map jsonHeader = jwtWrapper.getJsonHeaderAsMap();
        String apiKeyId = (String)this.getRequiredValue(jsonHeader, "kid");
        this.getJwtSignatureValidator(apiKeyId).validate(jwtWrapper);
        Number expire = (Number)this.getRequiredValue(jsonPayload, "exp");
        this.verifyJwtIsNotExpired(expire.longValue());
        String issuer = (String)this.getRequiredValue(jsonPayload, "iss");
        if (this.isError(jsonPayload)) {
            throw new SamlRuntimeException(this.constructError(jsonPayload, jsonHeader));
        }
        String responseNonce = (String)this.getRequiredValue(jsonPayload, "irt");
        if (this.nonceStore.hasNonce(responseNonce)) {
            throw new InvalidJwtException("JWT has already been used.");
        }
        this.nonceStore.putNonce(responseNonce);
        String accountHref = (String)this.getOptionalValue(jsonPayload, "sub");
        boolean accountHrefPresent = Strings.hasText((String)accountHref);
        SamlResultStatus resultStatus = SamlResultStatus.valueOf((String)this.getRequiredValue(jsonPayload, "status"));
        if (!accountHrefPresent && !SamlResultStatus.LOGOUT.equals((Object)resultStatus)) {
            throw new InvalidJwtException("Required jwtResponse parameter is missing.");
        }
        Boolean isNewAccount = (Boolean)this.getRequiredValue(jsonPayload, "isNewSub");
        String state = (String)this.getOptionalValue(jsonPayload, "state");
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put(DefaultAccountResult.NEW_ACCOUNT.getName(), isNewAccount);
        properties.put(DefaultAccountResult.STATE.getName(), state);
        if (accountHrefPresent) {
            HashMap<String, String> account = new HashMap<String, String>();
            account.put("href", accountHref);
            properties.put(DefaultAccountResult.ACCOUNT.getName(), account);
        }
        DefaultAccountResult accountResult = new DefaultAccountResult(this.dataStore, properties);
        if (this.resultListeners.size() > 0) {
            this.dispatchResponseStatus(resultStatus, properties);
        }
        return accountResult;
    }

    public SamlCallbackHandler setResultListener(SamlResultListener idSiteResultListener) {
        if (idSiteResultListener != null) {
            this.resultListeners = new ArrayList<SamlResultListener>();
            return this.addResultListener(idSiteResultListener);
        }
        return this;
    }

    public SamlCallbackHandler addResultListener(SamlResultListener idSiteResultListener) {
        if (idSiteResultListener != null) {
            this.resultListeners.add(idSiteResultListener);
        }
        return this;
    }

    private String getJwtResponse(Object httpRequestObject) {
        String jwtResponse;
        if (HttpRequest.class.isAssignableFrom(httpRequestObject.getClass())) {
            HttpRequest httpRequest = (HttpRequest)httpRequestObject;
            Assert.isTrue((httpRequest.getMethod() == HttpMethod.GET ? 1 : 0) != 0, (String)"Only Http GET method is supported.");
            jwtResponse = httpRequest.getParameter("jwtResponse");
        } else {
            if (HTTP_SERVLET_REQUEST_WRAPPER_CLASS == null) {
                throw new RuntimeException("DefaultHttpServletRequestWrapper not loaded error occurred while handling httpRequest of type: " + httpRequestObject.getClass().getName());
            }
            Constructor ctor = Classes.getConstructor(HTTP_SERVLET_REQUEST_WRAPPER_CLASS, (Class[])new Class[]{Object.class});
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{httpRequestObject});
            HttpMethod method = HttpMethod.fromName((String)httpServletRequestWrapper.getMethod());
            Assert.isTrue((HttpMethod.GET == method ? 1 : 0) != 0, (String)"Only Http GET method is supported.");
            jwtResponse = httpServletRequestWrapper.getParameter("jwtResponse");
        }
        if (!Strings.hasText((String)jwtResponse)) {
            throw new InvalidJwtException("JWT parameter is required..");
        }
        return jwtResponse;
    }

    private void verifyJwtIsNotExpired(long expireInSeconds) {
        long now = System.currentTimeMillis() / 1000L;
        if (now > expireInSeconds) {
            throw new InvalidJwtException("JWT has already expired.");
        }
    }

    private JwtSignatureValidator getJwtSignatureValidator(String jwtApiKeyId) {
        ApiKey apiKey = this.dataStore.getApiKey();
        if (apiKey.getId().equals(jwtApiKeyId)) {
            return new JwtSignatureValidator(apiKey);
        }
        throw new InvalidJwtException("The client used to sign the jwrResponse is different than the one used in this datasore.");
    }

    private <T> T getRequiredValue(Map jsonMap, String parameterName) {
        Object object = jsonMap.get(parameterName);
        if (object == null) {
            throw new InvalidJwtException("Required jwtResponse parameter is missing.");
        }
        return (T)object;
    }

    private <T> T getOptionalValue(Map jsonMap, String parameterName) {
        Object object = jsonMap.get(parameterName);
        if (object == null) {
            return null;
        }
        return (T)object;
    }

    private void dispatchResponseStatus(SamlResultStatus status, Map<String, Object> properties) {
        switch (status) {
            case AUTHENTICATED: {
                for (SamlResultListener resultListener : this.resultListeners) {
                    resultListener.onAuthenticated((AuthenticationResult)new DefaultAuthenticationResult(this.dataStore, properties));
                }
                break;
            }
            case LOGOUT: {
                for (SamlResultListener resultListener : this.resultListeners) {
                    resultListener.onLogout((LogoutResult)new DefaultLogoutResult(this.dataStore, properties));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Encountered unknown IdSite result status: " + (Object)((Object)status));
            }
        }
    }

    private Error constructError(Map jsonMap, Map jsonHeader) {
        Map errorMap = (Map)this.getRequiredValue(jsonMap, "err");
        if (jsonHeader.containsKey("Stormpath-Request-Id")) {
            errorMap.put("Stormpath-Request-Id", jsonHeader.get("Stormpath-Request-Id"));
        }
        return new DefaultError(errorMap);
    }

    private boolean isError(Map jsonMap) {
        Assert.notNull((Object)jsonMap, (String)"jsonMap cannot be null.");
        Object error = this.getOptionalValue(jsonMap, "err");
        return error != null;
    }
}

