/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.tenant;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.EmailVerificationToken;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationCriteria;
import com.stormpath.sdk.application.ApplicationList;
import com.stormpath.sdk.application.Applications;
import com.stormpath.sdk.application.CreateApplicationRequest;
import com.stormpath.sdk.directory.CreateDirectoryRequest;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.directory.DirectoryList;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.impl.application.CreateApplicationAndDirectoryRequest;
import com.stormpath.sdk.impl.application.CreateApplicationRequestVisitor;
import com.stormpath.sdk.impl.application.DefaultCreateApplicationRequest;
import com.stormpath.sdk.impl.directory.DefaultDirectory;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.organization.CreateOrganizationAndDirectoryRequest;
import com.stormpath.sdk.impl.organization.CreateOrganizationRequestVisitor;
import com.stormpath.sdk.impl.organization.DefaultCreateOrganizationRequest;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.organization.CreateOrganizationRequest;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationCriteria;
import com.stormpath.sdk.organization.OrganizationList;
import com.stormpath.sdk.organization.Organizations;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import com.stormpath.sdk.tenant.TenantOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultTenant
extends AbstractExtendableInstanceResource
implements Tenant {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty KEY = new StringProperty("key");
    static final CollectionReference<ApplicationList, Application> APPLICATIONS = new CollectionReference<ApplicationList, Application>("applications", ApplicationList.class, Application.class);
    static final CollectionReference<DirectoryList, Directory> DIRECTORIES = new CollectionReference<DirectoryList, Directory>("directories", DirectoryList.class, Directory.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    static final CollectionReference<OrganizationList, Organization> ORGANIZATIONS = new CollectionReference<OrganizationList, Organization>("organizations", OrganizationList.class, Organization.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultTenant.createPropertyDescriptorMap(NAME, KEY, APPLICATIONS, DIRECTORIES, CUSTOM_DATA, ACCOUNTS, GROUPS, ORGANIZATIONS);

    public DefaultTenant(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTenant(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public String getKey() {
        return this.getString(KEY);
    }

    public Application createApplication(Application application) {
        CreateApplicationRequest request = Applications.newCreateRequestFor((Application)application).build();
        return this.createApplication(request);
    }

    public Application createApplication(CreateApplicationRequest ar) {
        Assert.isInstanceOf(DefaultCreateApplicationRequest.class, (Object)ar);
        DefaultCreateApplicationRequest request = (DefaultCreateApplicationRequest)ar;
        Application application = request.getApplication();
        final String[] href = new String[]{"/" + APPLICATIONS.getName()};
        request.accept(new CreateApplicationRequestVisitor(){

            @Override
            public void visit(DefaultCreateApplicationRequest ignored) {
            }

            @Override
            public void visit(CreateApplicationAndDirectoryRequest request) {
                String name = request.getDirectoryName();
                if (name == null) {
                    name = "true";
                }
                href[0] = href[0] + "?createDirectory=" + name;
            }
        });
        return this.getDataStore().create(href[0], application);
    }

    public ApplicationList getApplications() {
        return (ApplicationList)this.getResourceProperty(APPLICATIONS);
    }

    public ApplicationList getApplications(Map<String, Object> queryParams) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, queryParams);
    }

    public ApplicationList getApplications(ApplicationCriteria criteria) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, (Criteria)criteria);
    }

    public Organization createOrganization(Organization organization) {
        CreateOrganizationRequest request = Organizations.newCreateRequestFor((Organization)organization).build();
        return this.createOrganization(request);
    }

    public Organization createOrganization(CreateOrganizationRequest orgRequest) throws ResourceException {
        Assert.isInstanceOf(DefaultCreateOrganizationRequest.class, (Object)orgRequest);
        DefaultCreateOrganizationRequest request = (DefaultCreateOrganizationRequest)orgRequest;
        Organization organization = request.getOrganization();
        final String[] href = new String[]{"/" + ORGANIZATIONS.getName()};
        request.accept(new CreateOrganizationRequestVisitor(){

            @Override
            public void visit(DefaultCreateOrganizationRequest ignored) {
            }

            @Override
            public void visit(CreateOrganizationAndDirectoryRequest request) {
                String name = request.getDirectoryName();
                if (name == null) {
                    name = "true";
                }
                href[0] = href[0] + "?createDirectory=" + name;
            }
        });
        return this.getDataStore().create(href[0], organization);
    }

    public OrganizationList getOrganizations() {
        return (OrganizationList)this.getResourceProperty(ORGANIZATIONS);
    }

    public OrganizationList getOrganizations(Map<String, Object> queryParams) {
        OrganizationList proxy = this.getOrganizations();
        return this.getDataStore().getResource(proxy.getHref(), OrganizationList.class, queryParams);
    }

    public OrganizationList getOrganizations(OrganizationCriteria criteria) {
        OrganizationList proxy = this.getOrganizations();
        return this.getDataStore().getResource(proxy.getHref(), OrganizationList.class, (Criteria)criteria);
    }

    public Directory createDirectory(Directory directory) {
        Assert.notNull((Object)directory, (String)"Directory instance cannot be null.");
        return this.getDataStore().create("/" + DIRECTORIES.getName(), directory);
    }

    public Directory createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        Assert.notNull((Object)createDirectoryRequest, (String)"createDirectoryRequest cannot be null.");
        Assert.notNull((Object)createDirectoryRequest.getDirectory(), (String)"the specified directory cannot be null.");
        Directory directory = createDirectoryRequest.getDirectory();
        if (createDirectoryRequest.getProvider() != null) {
            Assert.isAssignable(DefaultDirectory.class, directory.getClass(), (String)("the directory instance is of an unidentified type. The specified provider cannot be set to it: " + createDirectoryRequest.getDirectory()));
            ((DefaultDirectory)directory).setProvider(createDirectoryRequest.getProvider());
        }
        return this.getDataStore().create("/" + DIRECTORIES.getName(), directory);
    }

    public DirectoryList getDirectories() {
        return (DirectoryList)this.getResourceProperty(DIRECTORIES);
    }

    public DirectoryList getDirectories(Map<String, Object> queryParams) {
        DirectoryList proxy = this.getDirectories();
        return this.getDataStore().getResource(proxy.getHref(), DirectoryList.class, queryParams);
    }

    public DirectoryList getDirectories(DirectoryCriteria criteria) {
        DirectoryList proxy = this.getDirectories();
        return this.getDataStore().getResource(proxy.getHref(), DirectoryList.class, (Criteria)criteria);
    }

    public Account verifyAccountEmail(String token) {
        String href = "/accounts/emailVerificationTokens/" + token;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", href);
        EmailVerificationToken evToken = this.getDataStore().instantiate(EmailVerificationToken.class, props);
        return this.getDataStore().save(evToken, Account.class);
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList proxy = this.getAccounts();
        return this.getDataStore().getResource(proxy.getHref(), AccountList.class, (Criteria)criteria);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList proxy = this.getAccounts();
        return this.getDataStore().getResource(proxy.getHref(), AccountList.class, queryParams);
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList proxy = this.getGroups();
        return this.getDataStore().getResource(proxy.getHref(), GroupList.class, (Criteria)criteria);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList proxy = this.getGroups();
        return this.getDataStore().getResource(proxy.getHref(), GroupList.class, queryParams);
    }

    public Tenant saveWithResponseOptions(TenantOptions responseOptions) {
        Assert.notNull((Object)responseOptions, (String)"responseOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)responseOptions);
        return this;
    }
}

