/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.helper;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.helper.MavenExecutionHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.errors.GitAPIException;

@Component(role=MavenExecutionHelper.class)
public class DefaultMavenExecutionHelper
implements MavenExecutionHelper {
    @Requirement
    protected Map<String, MavenExecutor> mavenExecutors;
    @Requirement
    protected MavenProjectBuilder projectBuilder;
    @Requirement
    protected JGitFlowProvider jGitFlowProvider;
    @Requirement
    private ContextProvider contextProvider;

    @Override
    public void execute(MavenProject project, MavenSession session) throws MavenExecutorException {
        ReleaseContext ctx = this.contextProvider.getContext();
        String goal = ctx.getGoals();
        if (ctx.isNoDeploy()) {
            goal = "clean install";
        }
        this.execute(project, session, goal);
    }

    @Override
    public void execute(MavenProject project, MavenSession session, String goals) throws MavenExecutorException {
        String args;
        ReleaseContext ctx = this.contextProvider.getContext();
        ArrayList<String> argList = new ArrayList<String>();
        if (ctx.isUseReleaseProfile()) {
            argList.add("-DperformRelease=true");
        }
        if (Strings.isNullOrEmpty((String)(args = ctx.getArgs()))) {
            Properties userProps = session.getUserProperties();
            for (String key : userProps.stringPropertyNames()) {
                argList.add("-D" + key + "=\"" + userProps.getProperty(key) + "\"");
            }
            for (String profileId : this.getActiveProfileIds(project, session)) {
                argList.add("-P" + profileId);
            }
        } else {
            argList.add(args.trim());
        }
        String additionalArgs = Joiner.on((String)" ").join(argList);
        ReleaseResult result = new ReleaseResult();
        DefaultReleaseEnvironment env = new DefaultReleaseEnvironment();
        env.setSettings(session.getSettings());
        MavenExecutor mavenExecutor = this.mavenExecutors.get(env.getMavenExecutorId());
        mavenExecutor.executeGoals(ctx.getBaseDir(), goals, (ReleaseEnvironment)env, ctx.isInteractive(), additionalArgs, result);
    }

    @Override
    public MavenSession reloadReactor(MavenProject rootProject, MavenSession oldSession) throws ReactorReloadException {
        ArrayList<MavenProject> reactorProjects = new ArrayList<MavenProject>();
        ArrayList pomFiles = Lists.newArrayList((Object[])new File[]{rootProject.getFile()});
        try {
            block12: {
                MavenProject project = null;
                try {
                    if (!rootProject.getFile().exists() || !rootProject.getFile().canRead()) break block12;
                    Method getRequestMethod = oldSession.getClass().getMethod("getRequest", new Class[0]);
                    Object mavenExecutionRequest = getRequestMethod.invoke((Object)oldSession, new Object[0]);
                    Method getProjectBuildingRequest = mavenExecutionRequest.getClass().getMethod("getProjectBuildingRequest", new Class[0]);
                    Object pbr = getProjectBuildingRequest.invoke(mavenExecutionRequest, new Object[0]);
                    Object pb = oldSession.getContainer().lookup("org.apache.maven.project.ProjectBuilder");
                    Class<?> requestClass = Class.forName("org.apache.maven.project.ProjectBuildingRequest");
                    Method buildMethod = pb.getClass().getMethod("build", List.class, Boolean.TYPE, requestClass);
                    List results = (List)buildMethod.invoke(pb, pomFiles, true, pbr);
                    for (Object result : results) {
                        Method getProjectMethod = result.getClass().getMethod("getProject", new Class[0]);
                        getProjectMethod.setAccessible(true);
                        project = (MavenProject)getProjectMethod.invoke(result, new Object[0]);
                        project.setActiveProfiles(rootProject.getActiveProfiles());
                        reactorProjects.add(project);
                    }
                }
                catch (Exception e) {
                    try {
                        oldSession.getClass().getMethod("getProjectBuilderConfiguration", new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        throw e;
                    }
                    Stack<File> projectFiles = new Stack<File>();
                    projectFiles.push(rootProject.getFile());
                    while (!projectFiles.isEmpty()) {
                        File file = (File)projectFiles.pop();
                        if (!file.exists() || !file.canRead()) continue;
                        project = this.projectBuilder.build(file, oldSession.getProjectBuilderConfiguration());
                        project.setActiveProfiles(rootProject.getActiveProfiles());
                        List moduleNames = project.getModules();
                        for (String moduleName : moduleNames) {
                            File baseFile = new File(file.getParentFile(), moduleName);
                            if (baseFile.isFile()) {
                                projectFiles.push(baseFile);
                                continue;
                            }
                            projectFiles.push(new File(baseFile, File.separator + "pom.xml"));
                        }
                        reactorProjects.add(project);
                    }
                }
            }
            ReactorManager reactorManager = new ReactorManager(reactorProjects);
            MavenSession newSession = new MavenSession(oldSession.getContainer(), oldSession.getSettings(), oldSession.getLocalRepository(), oldSession.getEventDispatcher(), reactorManager, oldSession.getGoals(), oldSession.getExecutionRootDirectory(), oldSession.getExecutionProperties(), oldSession.getUserProperties(), oldSession.getStartTime());
            try {
                Method setProjectsMethod = newSession.getClass().getMethod("setProjects", List.class);
                setProjectsMethod.invoke((Object)newSession, reactorManager.getSortedProjects());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return newSession;
        }
        catch (Exception e) {
            throw new ReactorReloadException("Error reloading Maven reactor projects", e);
        }
    }

    @Override
    public MavenSession getSessionForBranch(String branchName, MavenProject rootProject, MavenSession oldSession) throws JGitFlowException, IOException, GitAPIException, ReactorReloadException {
        JGitFlow flow = this.jGitFlowProvider.gitFlow();
        String originalBranch = flow.git().getRepository().getBranch();
        flow.git().checkout().setName(branchName).call();
        MavenSession newSession = this.reloadReactor(rootProject, oldSession);
        flow.git().checkout().setName(originalBranch).call();
        return newSession;
    }

    private List<String> getActiveProfileIds(MavenProject project, MavenSession session) {
        List<String> profiles = new ArrayList<String>();
        try {
            Method getRequestMethod = session.getClass().getMethod("getRequest", new Class[0]);
            Object mavenExecutionRequest = getRequestMethod.invoke((Object)session, new Object[0]);
            Method getActiveProfilesMethod = mavenExecutionRequest.getClass().getMethod("getActiveProfiles", new Class[0]);
            profiles = (List)getActiveProfilesMethod.invoke(mavenExecutionRequest, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (project.getActiveProfiles() != null && !project.getActiveProfiles().isEmpty()) {
            for (Object profile : project.getActiveProfiles()) {
                profiles.add(((Profile)profile).getId());
            }
        }
        return profiles;
    }
}

