/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CommandMetrics {
    private final long count;
    private final TimeUnit timeUnit;
    private final CommandLatency firstResponse;
    private final CommandLatency completion;

    public CommandMetrics(long count, TimeUnit timeUnit, CommandLatency firstResponse, CommandLatency completion) {
        this.count = count;
        this.timeUnit = timeUnit;
        this.firstResponse = firstResponse;
        this.completion = completion;
    }

    public long getCount() {
        return this.count;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public CommandLatency getFirstResponse() {
        return this.firstResponse;
    }

    public CommandLatency getCompletion() {
        return this.completion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[count=").append(this.count);
        sb.append(", timeUnit=").append((Object)this.timeUnit);
        sb.append(", firstResponse=").append(this.firstResponse);
        sb.append(", completion=").append(this.completion);
        sb.append(']');
        return sb.toString();
    }

    public static class CommandLatency {
        private final long min;
        private final long max;
        private final Map<Double, Long> percentiles;

        public CommandLatency(long min, long max, Map<Double, Long> percentiles) {
            this.min = min;
            this.max = max;
            this.percentiles = percentiles;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public Map<Double, Long> getPercentiles() {
            return this.percentiles;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[min=").append(this.min);
            sb.append(", max=").append(this.max);
            sb.append(", percentiles=").append(this.percentiles);
            sb.append(']');
            return sb.toString();
        }
    }
}

