/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.io.netty.util;

import io.micrometer.shaded.io.netty.util.IllegalReferenceCountException;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.io.netty.util.internal.ObjectUtil;
import io.micrometer.shaded.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private static final long REFCNT_FIELD_OFFSET;
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCounted> refCntUpdater;
    private volatile int refCnt = 2;

    private static int realRefCnt(int rawCnt) {
        return (rawCnt & 1) != 0 ? 0 : rawCnt >>> 1;
    }

    private int nonVolatileRawCnt() {
        return REFCNT_FIELD_OFFSET != -1L ? PlatformDependent.getInt(this, REFCNT_FIELD_OFFSET) : refCntUpdater.get(this);
    }

    @Override
    public int refCnt() {
        return AbstractReferenceCounted.realRefCnt(refCntUpdater.get(this));
    }

    protected final void setRefCnt(int newRefCnt) {
        refCntUpdater.set(this, newRefCnt << 1);
    }

    @Override
    public ReferenceCounted retain() {
        return this.retain0(1);
    }

    @Override
    public ReferenceCounted retain(int increment) {
        return this.retain0(ObjectUtil.checkPositive(increment, "increment"));
    }

    private ReferenceCounted retain0(int increment) {
        int adjustedIncrement = increment << 1;
        int oldRef = refCntUpdater.getAndAdd(this, adjustedIncrement);
        if ((oldRef & 1) != 0) {
            throw new IllegalReferenceCountException(0, increment);
        }
        if (oldRef <= 0 && oldRef + adjustedIncrement >= 0 || oldRef >= 0 && oldRef + adjustedIncrement < oldRef) {
            refCntUpdater.getAndAdd(this, -adjustedIncrement);
            throw new IllegalReferenceCountException(AbstractReferenceCounted.realRefCnt(oldRef), increment);
        }
        return this;
    }

    @Override
    public ReferenceCounted touch() {
        return this.touch(null);
    }

    @Override
    public boolean release() {
        return this.release0(1);
    }

    @Override
    public boolean release(int decrement) {
        return this.release0(ObjectUtil.checkPositive(decrement, "decrement"));
    }

    private boolean release0(int decrement) {
        int rawCnt = this.nonVolatileRawCnt();
        int realCnt = AbstractReferenceCounted.toLiveRealCnt(rawCnt, decrement);
        if (decrement == realCnt) {
            if (refCntUpdater.compareAndSet(this, rawCnt, 1)) {
                this.deallocate();
                return true;
            }
            return this.retryRelease0(decrement);
        }
        return this.releaseNonFinal0(decrement, rawCnt, realCnt);
    }

    private boolean releaseNonFinal0(int decrement, int rawCnt, int realCnt) {
        if (decrement < realCnt && refCntUpdater.compareAndSet(this, rawCnt, rawCnt - (decrement << 1))) {
            return false;
        }
        return this.retryRelease0(decrement);
    }

    private boolean retryRelease0(int decrement) {
        while (true) {
            int rawCnt;
            int realCnt;
            if (decrement == (realCnt = AbstractReferenceCounted.toLiveRealCnt(rawCnt = refCntUpdater.get(this), decrement))) {
                if (refCntUpdater.compareAndSet(this, rawCnt, 1)) {
                    this.deallocate();
                    return true;
                }
            } else if (decrement < realCnt) {
                if (refCntUpdater.compareAndSet(this, rawCnt, rawCnt - (decrement << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(realCnt, -decrement);
            }
            Thread.yield();
        }
    }

    private static int toLiveRealCnt(int rawCnt, int decrement) {
        if ((rawCnt & 1) == 0) {
            return rawCnt >>> 1;
        }
        throw new IllegalReferenceCountException(0, -decrement);
    }

    protected abstract void deallocate();

    static {
        refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCounted.class, "refCnt");
        long refCntFieldOffset = -1L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                refCntFieldOffset = PlatformDependent.objectFieldOffset(AbstractReferenceCounted.class.getDeclaredField("refCnt"));
            }
        }
        catch (Throwable ignore) {
            refCntFieldOffset = -1L;
        }
        REFCNT_FIELD_OFFSET = refCntFieldOffset;
    }
}

