/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.postgresql;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.Defaultable;
import io.seata.sqlparser.struct.Sequenceable;
import io.seata.sqlparser.struct.SqlDefaultExpr;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="postgresql", scope=Scope.PROTOTYPE)
public class PostgresqlInsertExecutor
extends BaseInsertExecutor
implements Sequenceable,
Defaultable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresqlInsertExecutor.class);

    public PostgresqlInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap = null;
        Boolean isContainsPk = this.containsPK();
        if (isContainsPk.booleanValue()) {
            pkValuesMap = this.getPkValuesByColumn();
        } else if (this.containsColumns()) {
            String columnName = this.getTableMeta().getPrimaryKeyOnlyName().get(0);
            pkValuesMap = Collections.singletonMap(columnName, this.getGeneratedKeys());
        } else {
            pkValuesMap = this.getPkValuesByColumn();
        }
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        String pkKey;
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        List<Object> pkValues = pkValuesMap.get(pkKey = pkValuesMap.keySet().iterator().next());
        if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlSequenceExpr) {
            pkValuesMap.put(pkKey, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(0)));
        } else if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlMethodExpr) {
            pkValuesMap.put(pkKey, this.getGeneratedKeys());
        } else if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlDefaultExpr) {
            pkValuesMap.put(pkKey, this.getPkValuesByDefault());
        }
        return pkValuesMap;
    }

    @Override
    public List<Object> getPkValuesByDefault() throws SQLException {
        Map<String, ColumnMeta> pkMetaMap = this.getTableMeta().getPrimaryKeyMap();
        ColumnMeta pkMeta = pkMetaMap.values().iterator().next();
        String columnDef = pkMeta.getColumnDef();
        String seq = org.apache.commons.lang.StringUtils.substringBetween((String)columnDef, (String)"'", (String)"'");
        String function = org.apache.commons.lang.StringUtils.substringBetween((String)columnDef, (String)"", (String)"(");
        if (StringUtils.isBlank(seq)) {
            throw new ShouldNeverHappenException("get primary key value failed, cause columnDef is " + columnDef);
        }
        return this.getPkValuesBySequence(new SqlSequenceExpr("'" + seq + "'", function));
    }

    @Override
    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT currval(" + expr.getSequence() + ")";
    }
}

