/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import io.netty.util.internal.ConcurrentSet;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationChangeType;
import io.seata.config.ConfigurationFactory;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ApolloConfiguration
extends AbstractConfiguration {
    private static final String REGISTRY_TYPE = "apollo";
    private static final String APP_ID = "app.id";
    private static final String APOLLO_META = "apollo.meta";
    private static final String NAMESPACE = "namespace";
    private static final String DEFAULT_NAMESPACE = "application";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static volatile Config config;
    private ExecutorService configOperateExecutor;
    private static final int CORE_CONFIG_OPERATE_THREAD = 1;
    private static final ConcurrentMap<String, Set<ConfigurationChangeListener>> LISTENER_SERVICE_MAP;
    private static final int MAX_CONFIG_OPERATE_THREAD = 2;
    private static volatile ApolloConfiguration instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApolloConfiguration() {
        this.readyApolloConfig();
        if (null != config) return;
        Class<ApolloConfiguration> clazz = ApolloConfiguration.class;
        synchronized (ApolloConfiguration.class) {
            if (null != config) return;
            config = ConfigService.getConfig((String)FILE_CONFIG.getConfig(ApolloConfiguration.getApolloNamespaceKey(), DEFAULT_NAMESPACE));
            this.configOperateExecutor = new ThreadPoolExecutor(1, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("apolloConfigOperate", 2));
            config.addChangeListener(changeEvent -> {
                for (String key : changeEvent.changedKeys()) {
                    if (!LISTENER_SERVICE_MAP.containsKey(key)) continue;
                    ConfigChange change = changeEvent.getChange(key);
                    ConfigurationChangeEvent event = new ConfigurationChangeEvent(key, change.getNamespace(), change.getOldValue(), change.getNewValue(), this.getChangeType(change.getChangeType()));
                    ((Set)LISTENER_SERVICE_MAP.get(key)).forEach(listener -> listener.onProcessEvent(event));
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApolloConfiguration getInstance() {
        if (null != instance) return instance;
        Class<ApolloConfiguration> clazz = ApolloConfiguration.class;
        synchronized (ApolloConfiguration.class) {
            if (null != instance) return instance;
            instance = new ApolloConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.configOperateExecutor.submit(() -> {
            String result = config.getProperty(dataId, defaultValue);
            configFuture.setResult((Object)result);
        });
        return (String)configFuture.get();
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support putConfig");
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        throw new NotSupportYetException("not support removeConfig");
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (null == dataId || null == listener) {
            return;
        }
        LISTENER_SERVICE_MAP.putIfAbsent(dataId, (Set<ConfigurationChangeListener>)new ConcurrentSet());
        ((Set)LISTENER_SERVICE_MAP.get(dataId)).add(listener);
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (!LISTENER_SERVICE_MAP.containsKey(dataId) || listener == null) {
            return;
        }
        ((Set)LISTENER_SERVICE_MAP.get(dataId)).remove(listener);
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)LISTENER_SERVICE_MAP.get(dataId);
    }

    private void readyApolloConfig() {
        Properties properties = System.getProperties();
        if (!properties.containsKey(APP_ID)) {
            System.setProperty(APP_ID, FILE_CONFIG.getConfig(ApolloConfiguration.getApolloAppIdFileKey()));
        }
        if (!properties.containsKey(APOLLO_META)) {
            System.setProperty(APOLLO_META, FILE_CONFIG.getConfig(ApolloConfiguration.getApolloMetaFileKey()));
        }
    }

    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    private static String getApolloMetaFileKey() {
        return String.join((CharSequence)".", "config", REGISTRY_TYPE, APOLLO_META);
    }

    private static String getApolloAppIdFileKey() {
        return String.join((CharSequence)".", "config", REGISTRY_TYPE, APP_ID);
    }

    private static String getApolloNamespaceKey() {
        return String.join((CharSequence)".", "config", REGISTRY_TYPE, NAMESPACE);
    }

    private ConfigurationChangeType getChangeType(PropertyChangeType changeType) {
        switch (changeType) {
            case ADDED: {
                return ConfigurationChangeType.ADD;
            }
            case DELETED: {
                return ConfigurationChangeType.DELETE;
            }
        }
        return ConfigurationChangeType.MODIFY;
    }

    static {
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>();
    }
}

