/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.batch;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecuteUnit;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorDataMap;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BatchPreparedStatementExecutor {
    private final DatabaseType dbType;
    private final SQLType sqlType;
    private final int batchCount;

    public int[] executeBatch() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Map dataMap = ExecutorDataMap.getDataMap();
        SQLExecuteCallback<int[]> callback = new SQLExecuteCallback<int[]>(this.sqlType, isExceptionThrown, dataMap){

            protected int[] executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return sqlExecuteUnit.getStatement().executeBatch();
            }
        };
        return this.accumulate(this.executeCallback(callback));
    }

    private int[] accumulate(List<int[]> results) {
        int[] result = new int[this.batchCount];
        int count = 0;
        for (BatchPreparedStatementExecuteUnit each : this.getBatchPreparedStatementUnitGroups()) {
            for (Map.Entry<Integer, Integer> entry : each.getJdbcAndActualAddBatchCallTimesMap().entrySet()) {
                int value;
                int n = value = null == results.get(count) ? 0 : results.get(count)[entry.getValue()];
                if (DatabaseType.Oracle == this.dbType) {
                    result[entry.getKey().intValue()] = value;
                    continue;
                }
                int n2 = entry.getKey();
                result[n2] = result[n2] + value;
            }
            ++count;
        }
        return result;
    }

    protected abstract <T> List<T> executeCallback(SQLExecuteCallback<T> var1) throws SQLException;

    protected abstract Collection<BatchPreparedStatementExecuteUnit> getBatchPreparedStatementUnitGroups();

    @ConstructorProperties(value={"dbType", "sqlType", "batchCount"})
    public BatchPreparedStatementExecutor(DatabaseType dbType, SQLType sqlType, int batchCount) {
        this.dbType = dbType;
        this.sqlType = sqlType;
        this.batchCount = batchCount;
    }
}

