/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.batch;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecuteUnit;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecutor;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ConnectionStrictlyBatchPreparedStatementExecutor
extends BatchPreparedStatementExecutor {
    private final SQLExecuteTemplate executeTemplate;
    private final List<List<BatchPreparedStatementExecuteUnit>> batchPreparedStatementUnitGroups;

    public ConnectionStrictlyBatchPreparedStatementExecutor(DatabaseType dbType, SQLType sqlType, int batchCount, SQLExecuteTemplate executeTemplate, List<List<BatchPreparedStatementExecuteUnit>> batchPreparedStatementUnitGroups) {
        super(dbType, sqlType, batchCount);
        this.executeTemplate = executeTemplate;
        this.batchPreparedStatementUnitGroups = batchPreparedStatementUnitGroups;
    }

    @Override
    protected <T> List<T> executeCallback(SQLExecuteCallback<T> executeCallback) throws SQLException {
        return this.executeTemplate.executeGroup(this.batchPreparedStatementUnitGroups, executeCallback);
    }

    @Override
    protected Collection<BatchPreparedStatementExecuteUnit> getBatchPreparedStatementUnitGroups() {
        LinkedList<BatchPreparedStatementExecuteUnit> result = new LinkedList<BatchPreparedStatementExecuteUnit>();
        for (List<BatchPreparedStatementExecuteUnit> each : this.batchPreparedStatementUnitGroups) {
            result.addAll(each);
        }
        return result;
    }
}

