/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.batch;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecuteUnit;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecutor;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class MemoryStrictlyBatchPreparedStatementExecutor
extends BatchPreparedStatementExecutor {
    private final SQLExecuteTemplate executeTemplate;
    private final Collection<BatchPreparedStatementExecuteUnit> batchPreparedStatementUnits;

    public MemoryStrictlyBatchPreparedStatementExecutor(DatabaseType dbType, SQLType sqlType, int batchCount, SQLExecuteTemplate executeTemplate, Collection<BatchPreparedStatementExecuteUnit> batchPreparedStatementUnits) {
        super(dbType, sqlType, batchCount);
        this.executeTemplate = executeTemplate;
        this.batchPreparedStatementUnits = batchPreparedStatementUnits;
    }

    @Override
    protected <T> List<T> executeCallback(SQLExecuteCallback<T> executeCallback) throws SQLException {
        return this.executeTemplate.execute(this.batchPreparedStatementUnits, executeCallback);
    }

    @Override
    protected Collection<BatchPreparedStatementExecuteUnit> getBatchPreparedStatementUnitGroups() {
        return this.batchPreparedStatementUnits;
    }
}

