/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.statement;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorDataMap;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public abstract class StatementExecutor {
    private final SQLType sqlType;

    public List<ResultSet> executeQuery() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Map dataMap = ExecutorDataMap.getDataMap();
        SQLExecuteCallback<ResultSet> executeCallback = new SQLExecuteCallback<ResultSet>(this.sqlType, isExceptionThrown, dataMap){

            protected ResultSet executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return sqlExecuteUnit.getStatement().executeQuery(sqlExecuteUnit.getRouteUnit().getSqlUnit().getSql());
            }
        };
        return this.executeCallback(executeCallback);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    private int executeUpdate(final Updater updater) throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Map dataMap = ExecutorDataMap.getDataMap();
        SQLExecuteCallback<Integer> executeCallback = new SQLExecuteCallback<Integer>(this.sqlType, isExceptionThrown, dataMap){

            protected Integer executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return updater.executeUpdate(sqlExecuteUnit.getStatement(), sqlExecuteUnit.getRouteUnit().getSqlUnit().getSql());
            }
        };
        List<Integer> results = this.executeCallback(executeCallback);
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    private boolean execute(final Executor executor) throws SQLException {
        Map dataMap;
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Boolean> executeCallback = new SQLExecuteCallback<Boolean>(this.sqlType, isExceptionThrown, dataMap = ExecutorDataMap.getDataMap()){

            protected Boolean executeSQL(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
                return executor.execute(sqlExecuteUnit.getStatement(), sqlExecuteUnit.getRouteUnit().getSqlUnit().getSql());
            }
        };
        List<Boolean> result = this.executeCallback(executeCallback);
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    protected abstract <T> List<T> executeCallback(SQLExecuteCallback<T> var1) throws SQLException;

    @ConstructorProperties(value={"sqlType"})
    public StatementExecutor(SQLType sqlType) {
        this.sqlType = sqlType;
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

