/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.adapter;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.transaction.TransactionOperationType;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.transaction.xa.XATransactionEvent;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.jdbc.adapter.executor.ForceExecuteCallback;
import io.shardingsphere.core.jdbc.adapter.executor.ForceExecuteTemplate;
import io.shardingsphere.core.jdbc.unsupported.AbstractUnsupportedOperationConnection;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.core.transaction.TransactionTypeHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractConnectionAdapter
extends AbstractUnsupportedOperationConnection {
    private final Map<String, Connection> cachedConnections = new HashMap<String, Connection>();
    private boolean autoCommit = true;
    private boolean readOnly = true;
    private boolean closed;
    private int transactionIsolation = 1;
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();

    public final Connection getConnection(String dataSourceName) throws SQLException {
        if (this.cachedConnections.containsKey(dataSourceName)) {
            return this.cachedConnections.get(dataSourceName);
        }
        DataSource dataSource = this.getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object[])new Object[]{dataSourceName});
        Connection result = dataSource.getConnection();
        this.cachedConnections.put(dataSourceName, result);
        this.replayMethodsInvocation(result);
        return result;
    }

    protected abstract Map<String, DataSource> getDataSourceMap();

    protected final void removeCache(Connection connection) {
        this.cachedConnections.values().remove(connection);
    }

    @Override
    public final boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public final void setAutoCommit(final boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.setAutoCommit(autoCommit);
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.BEGIN));
        }
    }

    @Override
    public final void commit() throws SQLException {
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.commit();
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.COMMIT));
        }
    }

    @Override
    public final void rollback() throws SQLException {
        if (TransactionType.LOCAL == TransactionTypeHolder.get()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    connection.rollback();
                }
            });
        } else if (TransactionType.XA == TransactionTypeHolder.get()) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent(TransactionOperationType.ROLLBACK));
        }
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        HintManagerHolder.clear();
        MasterVisitedManager.clear();
        TransactionTypeHolder.clear();
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.close();
            }
        });
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(final boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.recordMethodInvocation(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setReadOnly(readOnly);
            }
        });
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        if (this.cachedConnections.values().isEmpty()) {
            return this.transactionIsolation;
        }
        return this.cachedConnections.values().iterator().next().getTransactionIsolation();
    }

    @Override
    public final void setTransactionIsolation(final int level) throws SQLException {
        this.transactionIsolation = level;
        this.recordMethodInvocation(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setTransactionIsolation(level);
            }
        });
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public final int getHoldability() {
        return 2;
    }

    @Override
    public final void setHoldability(int holdability) {
    }
}

