/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingContext
implements AutoCloseable {
    private ShardingRule shardingRule;
    private DatabaseType databaseType;
    private ShardingExecuteEngine executeEngine;
    private ShardingMetaData metaData;
    private ConnectionMode connectionMode;
    private int maxConnectionsSizePerQuery;
    private boolean showSQL;

    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ShardingExecuteEngine executeEngine, ConnectionMode connectionMode, int maxConnectionsSizePerQuery, boolean showSQL) {
        this.init(dataSourceMap, shardingRule, databaseType, executeEngine, connectionMode, maxConnectionsSizePerQuery, showSQL);
    }

    private void init(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ShardingExecuteEngine executeEngine, ConnectionMode connectionMode, int maxConnectionsSizePerQuery, boolean showSQL) {
        this.shardingRule = shardingRule;
        this.executeEngine = executeEngine;
        this.databaseType = databaseType;
        this.connectionMode = connectionMode;
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.showSQL = showSQL;
        this.metaData = new ShardingMetaData(ShardingContext.getDataSourceURLs(dataSourceMap), shardingRule, databaseType, executeEngine, (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(dataSourceMap), maxConnectionsSizePerQuery);
    }

    private static Map<String, String> getDataSourceURLs(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.put(entry.getKey(), ShardingContext.getDataSourceURL(entry.getValue()));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDataSourceURL(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException ex) {
            throw new ShardingException((Exception)ex);
        }
    }

    @Override
    public void close() {
        this.executeEngine.close();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ShardingExecuteEngine getExecuteEngine() {
        return this.executeEngine;
    }

    public ShardingMetaData getMetaData() {
        return this.metaData;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public int getMaxConnectionsSizePerQuery() {
        return this.maxConnectionsSizePerQuery;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }
}

