/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.datasource;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.ConfigMapContext;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingProperties;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingContext shardingContext;
    private final ShardingProperties shardingProperties;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(dataSourceMap.values());
        this.checkDataSourceType(dataSourceMap);
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getShardingConfig().putAll(configMap);
        }
        this.dataSourceMap = dataSourceMap;
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        this.shardingContext = this.getShardingContext(dataSourceMap, shardingRule);
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingContext shardingContext, ShardingProperties shardingProperties, DatabaseType databaseType) {
        super(databaseType);
        this.dataSourceMap = dataSourceMap;
        this.shardingContext = shardingContext;
        this.shardingProperties = shardingProperties;
    }

    private void checkDataSourceType(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            Preconditions.checkArgument((!(each instanceof MasterSlaveDataSource) ? 1 : 0) != 0, (Object)"Initialized data sources can not be master-slave data sources.");
        }
    }

    private ShardingContext getShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) {
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        ShardingExecuteEngine executeEngine = new ShardingExecuteEngine(executorSize);
        ConnectionMode connectionMode = ConnectionMode.valueOf((String)((String)this.shardingProperties.getValue(ShardingPropertiesConstant.CONNECTION_MODE)));
        int maxConnectionsSizePerQuery = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new ShardingContext(dataSourceMap, shardingRule, this.getDatabaseType(), executeEngine, connectionMode, maxConnectionsSizePerQuery, showSQL);
    }

    @Override
    public final ShardingConnection getConnection() {
        return new ShardingConnection(this);
    }

    @Override
    public final void close() {
        this.closeOriginalDataSources();
        this.shardingContext.close();
    }

    private void closeOriginalDataSources() {
        for (DataSource each : this.dataSourceMap.values()) {
            try {
                each.getClass().getDeclaredMethod("close", new Class[0]).invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

