/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.statement;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.merger.MergeEvent;
import io.shardingsphere.core.event.routing.RoutingEvent;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.batch.BatchPreparedStatementExecuteUnit;
import io.shardingsphere.core.executor.batch.ConnectionStrictlyBatchPreparedStatementExecutor;
import io.shardingsphere.core.executor.batch.MemoryStrictlyBatchPreparedStatementExecutor;
import io.shardingsphere.core.executor.prepared.ConnectionStrictlyPreparedStatementExecutor;
import io.shardingsphere.core.executor.prepared.MemoryStrictlyPreparedStatementExecutor;
import io.shardingsphere.core.executor.prepared.PreparedStatementExecuteUnit;
import io.shardingsphere.core.executor.prepared.PreparedStatementExecutor;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import io.shardingsphere.core.executor.sql.execute.result.MemoryQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareTemplate;
import io.shardingsphere.core.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.core.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.core.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.PreparedStatementRoutingEngine;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ShardingPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final PreparedStatementRoutingEngine routingEngine;
    private final List<BatchPreparedStatementExecuteUnit> batchStatementUnits = new LinkedList<BatchPreparedStatementExecuteUnit>();
    private final Collection<PreparedStatement> routedStatements = new LinkedList<PreparedStatement>();
    private final String sql;
    private int batchCount;
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingPreparedStatement(ShardingConnection connection, String sql) {
        this(connection, sql, 1003, 1007, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this(connection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int autoGeneratedKeys) {
        this(connection, sql);
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.sql = sql;
        ShardingContext shardingContext = connection.getShardingDataSource().getShardingContext();
        this.routingEngine = new PreparedStatementRoutingEngine(sql, shardingContext.getShardingRule(), shardingContext.getMetaData().getTable(), shardingContext.getDatabaseType(), shardingContext.isShowSQL(), shardingContext.getMetaData().getDataSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        this.routedStatements.clear();
        try {
            this.sqlRoute();
            List<ResultSet> resultSets = this.getPreparedStatementExecutor().executeQuery();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingDataSource().getShardingContext().getShardingRule(), this.getQueryResults(resultSets), (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable());
            result = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (ConnectionMode.MEMORY_STRICTLY == this.connection.getShardingDataSource().getShardingContext().getConnectionMode()) {
                result.add((QueryResult)new StreamQueryResult(each));
                continue;
            }
            result.add((QueryResult)new MemoryQueryResult(each));
        }
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.routedStatements.clear();
        try {
            this.sqlRoute();
            int n = this.getPreparedStatementExecutor().executeUpdate();
            return n;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.routedStatements.clear();
        try {
            this.sqlRoute();
            boolean bl = this.getPreparedStatementExecutor().execute();
            return bl;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    private void refreshTableMetaData() throws SQLException {
        if (null != this.routeResult && null != this.connection && SQLType.DDL == this.routeResult.getSqlStatement().getType() && !this.routeResult.getSqlStatement().getTables().isEmpty()) {
            String logicTableName = this.routeResult.getSqlStatement().getTables().getSingleTableName();
            TableMetaDataLoader tableMetaDataLoader = new TableMetaDataLoader(this.connection.getShardingDataSource().getShardingContext().getMetaData().getDataSource(), this.connection.getShardingDataSource().getShardingContext().getExecuteEngine(), (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(this.connection.getShardingDataSource().getDataSourceMap()), this.connection.getShardingDataSource().getShardingContext().getMaxConnectionsSizePerQuery());
            this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable().put(logicTableName, tableMetaDataLoader.load(logicTableName, this.connection.getShardingDataSource().getShardingContext().getShardingRule()));
        }
    }

    @Override
    public void clearBatch() {
        this.currentResultSet = null;
        this.clearParameters();
        this.batchStatementUnits.clear();
        this.batchCount = 0;
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            for (BatchPreparedStatementExecuteUnit each : this.routeBatch()) {
                each.getStatement().addBatch();
                each.mapAddBatchCount(this.batchCount);
            }
            ++this.batchCount;
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    private List<BatchPreparedStatementExecuteUnit> routeBatch() throws SQLException {
        ArrayList<BatchPreparedStatementExecuteUnit> result = new ArrayList<BatchPreparedStatementExecuteUnit>();
        this.sqlRoute();
        for (RouteUnit each : this.routeResult.getRouteUnits()) {
            BatchPreparedStatementExecuteUnit batchStatementUnit = this.getBatchPreparedStatementExecuteUnit(each);
            this.replaySetParameter(batchStatementUnit.getStatement(), (List)each.getSqlUnit().getParameterSets().get(0));
            result.add(batchStatementUnit);
        }
        return result;
    }

    private void sqlRoute() {
        RoutingEvent event = new RoutingEvent(this.sql);
        ShardingEventBusInstance.getInstance().post((Object)event);
        try {
            this.routeResult = this.routingEngine.route(this.getParameters());
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ShardingEventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
        event.setExecuteSuccess();
        ShardingEventBusInstance.getInstance().post((Object)event);
    }

    private PreparedStatementExecutor getPreparedStatementExecutor() throws SQLException {
        SQLExecuteTemplate sqlExecuteTemplate = new SQLExecuteTemplate(this.connection.getShardingDataSource().getShardingContext().getExecuteEngine());
        if (ConnectionMode.MEMORY_STRICTLY == this.connection.getShardingDataSource().getShardingContext().getConnectionMode()) {
            return new MemoryStrictlyPreparedStatementExecutor(this.routeResult.getSqlStatement().getType(), sqlExecuteTemplate, this.getExecuteUnitsForMemoryStrictly());
        }
        return new ConnectionStrictlyPreparedStatementExecutor(this.routeResult.getSqlStatement().getType(), sqlExecuteTemplate, this.getExecuteUnitsForConnectionStrictly());
    }

    private Collection<PreparedStatementExecuteUnit> getExecuteUnitsForMemoryStrictly() throws SQLException {
        LinkedList<PreparedStatementExecuteUnit> result = new LinkedList<PreparedStatementExecuteUnit>();
        for (RouteUnit each : this.routeResult.getRouteUnits()) {
            result.add(this.getPreparedStatementExecuteUnit(this.connection.getConnection(each.getDataSourceName()), each));
        }
        return result;
    }

    private Collection<ShardingExecuteGroup<PreparedStatementExecuteUnit>> getExecuteUnitsForConnectionStrictly() throws SQLException {
        SQLExecutePrepareTemplate sqlExecutePrepareTemplate = new SQLExecutePrepareTemplate(this.connection.getShardingDataSource().getShardingContext().getMaxConnectionsSizePerQuery());
        return sqlExecutePrepareTemplate.getExecuteUnitGroups(this.routeResult.getRouteUnits(), new SQLExecutePrepareCallback(){

            public Connection getConnection(String dataSourceName) throws SQLException {
                return ShardingPreparedStatement.this.connection.getConnection(dataSourceName);
            }

            public SQLExecuteUnit createSQLExecuteUnit(Connection connection, RouteUnit routeUnit) throws SQLException {
                return ShardingPreparedStatement.this.getPreparedStatementExecuteUnit(connection, routeUnit);
            }
        });
    }

    private PreparedStatementExecuteUnit getPreparedStatementExecuteUnit(Connection connection, RouteUnit routeUnit) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection, routeUnit.getSqlUnit().getSql());
        this.routedStatements.add(preparedStatement);
        this.replaySetParameter(preparedStatement, (List)routeUnit.getSqlUnit().getParameterSets().get(0));
        return new PreparedStatementExecuteUnit(routeUnit, preparedStatement);
    }

    private BatchPreparedStatementExecuteUnit getBatchPreparedStatementExecuteUnit(final RouteUnit routeUnit) throws SQLException {
        Optional preparedBatchStatement = Iterators.tryFind(this.batchStatementUnits.iterator(), (Predicate)new Predicate<BatchPreparedStatementExecuteUnit>(){

            public boolean apply(BatchPreparedStatementExecuteUnit input) {
                return Objects.equals(input.getRouteUnit(), routeUnit);
            }
        });
        if (preparedBatchStatement.isPresent()) {
            ((BatchPreparedStatementExecuteUnit)preparedBatchStatement.get()).getRouteUnit().getSqlUnit().getParameterSets().add(routeUnit.getSqlUnit().getParameterSets().get(0));
            return (BatchPreparedStatementExecuteUnit)preparedBatchStatement.get();
        }
        BatchPreparedStatementExecuteUnit result = new BatchPreparedStatementExecuteUnit(routeUnit, this.createPreparedStatement(this.connection.getConnection(routeUnit.getDataSourceName()), routeUnit.getSqlUnit().getSql()));
        this.batchStatementUnits.add(result);
        return result;
    }

    private PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            SQLExecuteTemplate sqlExecuteTemplate = new SQLExecuteTemplate(this.connection.getShardingDataSource().getShardingContext().getExecuteEngine());
            if (ConnectionMode.MEMORY_STRICTLY == this.connection.getShardingDataSource().getShardingContext().getConnectionMode()) {
                int[] nArray = new MemoryStrictlyBatchPreparedStatementExecutor(this.connection.getShardingDataSource().getShardingContext().getDatabaseType(), this.routeResult.getSqlStatement().getType(), this.batchCount, sqlExecuteTemplate, this.batchStatementUnits).executeBatch();
                return nArray;
            }
            int[] nArray = new ConnectionStrictlyBatchPreparedStatementExecutor(this.connection.getShardingDataSource().getShardingContext().getDatabaseType(), this.routeResult.getSqlStatement().getType(), this.batchCount, sqlExecuteTemplate, this.partitionBatchPreparedStatementUnitGroups()).executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private List<List<BatchPreparedStatementExecuteUnit>> partitionBatchPreparedStatementUnitGroups() {
        LinkedList<List<BatchPreparedStatementExecuteUnit>> result = new LinkedList<List<BatchPreparedStatementExecuteUnit>>();
        for (List<BatchPreparedStatementExecuteUnit> each : this.getBatchPreparedStatementUnitGroups().values()) {
            int desiredPartitionSize = Math.max(each.size() / this.connection.getShardingDataSource().getShardingContext().getMaxConnectionsSizePerQuery(), 1);
            result.addAll(Lists.partition(each, (int)desiredPartitionSize));
        }
        return result;
    }

    private Map<String, List<BatchPreparedStatementExecuteUnit>> getBatchPreparedStatementUnitGroups() {
        HashMap<String, List<BatchPreparedStatementExecuteUnit>> result = new HashMap<String, List<BatchPreparedStatementExecuteUnit>>(this.batchStatementUnits.size(), 1.0f);
        for (BatchPreparedStatementExecuteUnit each : this.batchStatementUnits) {
            String dataSourceName = each.getRouteUnit().getDataSourceName();
            if (!result.containsKey(dataSourceName)) {
                result.put(dataSourceName, new LinkedList());
            }
            ((List)result.get(dataSourceName)).add(each);
        }
        return result;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.routedStatements.size()) {
            return this.routedStatements.iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.routedStatements.size());
        for (PreparedStatement each : this.routedStatements) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new StreamQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingDataSource().getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingDataSource().getShardingContext().getMetaData().getTable());
            this.currentResultSet = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        return this.currentResultSet;
    }

    private MergedResult merge(MergeEngine mergeEngine) throws SQLException {
        MergeEvent event = new MergeEvent();
        try {
            ShardingEventBusInstance.getInstance().post((Object)event);
            MergedResult result = mergeEngine.merge();
            event.setExecuteSuccess();
            ShardingEventBusInstance.getInstance().post((Object)event);
            return result;
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ShardingEventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public PreparedStatementRoutingEngine getRoutingEngine() {
        return this.routingEngine;
    }

    public List<BatchPreparedStatementExecuteUnit> getBatchStatementUnits() {
        return this.batchStatementUnits;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.routedStatements;
    }

    public String getSql() {
        return this.sql;
    }

    public int getBatchCount() {
        return this.batchCount;
    }
}

