/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.staticdocs;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.Swagger2MarkupConverter;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public class Swagger2MarkupResultHandler
implements ResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Swagger2MarkupResultHandler.class);
    private final String outputDir;
    private final MarkupLanguage markupLanguage;
    private final String examplesFolderPath;
    private final String encoding = "UTF-8";

    Swagger2MarkupResultHandler(String outputDir, MarkupLanguage markupLanguage, String examplesFolderPath) {
        this.outputDir = outputDir;
        this.markupLanguage = markupLanguage;
        this.examplesFolderPath = examplesFolderPath;
    }

    public static Builder outputDirectory(String outputDir) {
        Validate.notEmpty((CharSequence)outputDir, (String)"outputDir must not be empty!", (Object[])new Object[0]);
        return new Builder(outputDir);
    }

    public void handle(MvcResult result) throws Exception {
        MockHttpServletResponse response = result.getResponse();
        response.setCharacterEncoding("UTF-8");
        String swaggerJson = response.getContentAsString();
        Swagger2MarkupConverter.fromString((String)swaggerJson).withMarkupLanguage(this.markupLanguage).withExamples(this.examplesFolderPath).build().intoFolder(this.outputDir);
    }

    public static class Builder {
        private final String outputDir;
        private String examplesFolderPath;
        private MarkupLanguage markupLanguage = MarkupLanguage.ASCIIDOC;

        Builder(String outputDir) {
            this.outputDir = outputDir;
        }

        public Swagger2MarkupResultHandler build() {
            return new Swagger2MarkupResultHandler(this.outputDir, this.markupLanguage, this.examplesFolderPath);
        }

        public Builder withMarkupLanguage(MarkupLanguage markupLanguage) {
            this.markupLanguage = markupLanguage;
            return this;
        }

        public Builder withExamples(String examplesFolderPath) {
            this.examplesFolderPath = examplesFolderPath;
            return this;
        }
    }
}

