/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.storage.mysql;

import java.util.List;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import zipkin2.autoconfigure.storage.mysql.ZipkinMySQLStorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.mysql.v1.MySQLStorage;

@Configuration
@EnableConfigurationProperties(value={ZipkinMySQLStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
@ConditionalOnMissingBean(value={StorageComponent.class})
class ZipkinMySQLStorageAutoConfiguration {
    @Autowired(required=false)
    ZipkinMySQLStorageProperties mysql;
    @Autowired(required=false)
    @Qualifier(value="tracingExecuteListenerProvider")
    ExecuteListenerProvider listener;

    ZipkinMySQLStorageAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    Executor executor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("ZipkinMySQLStorage-");
        executor.initialize();
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    DataSource mysqlDataSource() {
        return this.mysql.toDataSource();
    }

    @Bean
    StorageComponent storage(Executor executor, DataSource dataSource, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
        return MySQLStorage.newBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).executor(executor).datasource(dataSource).listenerProvider(this.listener).build();
    }
}

