/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.internal;

import java.io.IOException;
import zipkin2.Call;
import zipkin2.Callback;

public abstract class BaseCall<V>
extends Call<V> {
    volatile boolean canceled;
    boolean executed;

    protected BaseCall() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V execute() throws IOException {
        BaseCall baseCall = this;
        synchronized (baseCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        if (this.isCanceled()) {
            throw new IOException("Canceled");
        }
        return this.doExecute();
    }

    protected abstract V doExecute() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(Callback<V> callback) {
        BaseCall baseCall = this;
        synchronized (baseCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        if (this.isCanceled()) {
            callback.onError((Throwable)new IOException("Canceled"));
        } else {
            this.doEnqueue(callback);
        }
    }

    protected abstract void doEnqueue(Callback<V> var1);

    public final void cancel() {
        this.canceled = true;
        this.doCancel();
    }

    protected void doCancel() {
    }

    public final boolean isCanceled() {
        return this.canceled || this.doIsCanceled();
    }

    protected boolean doIsCanceled() {
        return false;
    }
}

