/*
 * Copyright (c) 2019-2029, Dreamlu 卢春梦 (596392912@qq.com & www.dreamlu.net).
 * <p>
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl.html
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreamlu.mica.core.utils;

/**
 * 静态 String 池
 *
 * @author L.cm
 */
public interface StringPool {
	// @formatter:off
	String AMPERSAND        = "&";
	String AND              = "and";
	String AT               = "@";
	String ASTERISK         = "*";
	String STAR             = ASTERISK;
	String BACK_SLASH       = "\\";
	String COLON            = ":";
	String COMMA            = ",";
	String DASH             = "-";
	String DOLLAR           = "$";
	String DOT              = ".";
	String EMPTY            = "";
	String EQUALS           = "=";
	String FALSE            = "false";
	String SLASH            = "/";
	String HASH             = "#";
	String HAT              = "^";
	String LEFT_BRACE       = "{";
	String LEFT_BRACKET     = "(";
	String LEFT_CHEV        = "<";
	String NEWLINE          = "\n";
	String N                = "n";
	String NO               = "no";
	String NULL             = "null";
	String OFF              = "off";
	String ON               = "on";
	String PERCENT          = "%";
	String PIPE             = "|";
	String PLUS             = "+";
	String QUESTION_MARK    = "?";
	String EXCLAMATION_MARK = "!";
	String QUOTE            = "\"";
	String RETURN           = "\r";
	String TAB              = "\t";
	String RIGHT_BRACE      = "}";
	String RIGHT_BRACKET    = ")";
	String RIGHT_CHEV       = ">";
	String SEMICOLON        = ";";
	String SINGLE_QUOTE     = "'";
	String BACKTICK         = "`";
	String SPACE            = " ";
	String TILDA            = "~";
	String LEFT_SQ_BRACKET  = "[";
	String RIGHT_SQ_BRACKET = "]";
	String TRUE             = "true";
	String UNDERSCORE       = "_";
	String UTF_8            = "UTF-8";
	String GBK              = "GBK";
	String Y                = "y";
	String YES              = "yes";
	String ONE              = "1";
	String ZERO             = "0";
	String DOLLAR_LEFT_BRACE= "${";
	String GET              = "get";
	String IS               = "is";
	String UNKNOWN          = "unknown";
	// @formatter:on
}
