/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterException;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.digest.FileDigester;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependenciesCheckMojo
extends AbstractMojo {
    public static final String NAME = "check";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="csvSummaryFile", defaultValue="dependencies-checksums.csv")
    protected String csvSummaryFile;
    @Parameter
    protected List<String> scopes;
    @Parameter
    protected List<String> types;
    @Parameter(property="transitive", defaultValue="false")
    protected boolean transitive;
    @Parameter(property="checksum.skip", defaultValue="false")
    protected boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping checksum:check execution because property checksum.skip is set.");
        } else if (this.skipPackaging("pom")) {
            this.getLog().warn((CharSequence)("The goal is skipped due to packaging '" + this.project.getPackaging() + "'"));
        } else {
            try {
                File summaryFile = FileUtils.resolveFile((File)new File(this.project.getBasedir().getAbsolutePath()), (String)this.csvSummaryFile);
                Map<String, Map<String, String>> summaryFileContent = this.readSummaryFile(summaryFile);
                this.checkDependencies(summaryFileContent);
            }
            catch (ExecutionException e) {
                this.getLog().error((CharSequence)e.getMessage());
                throw new MojoFailureException(e.getMessage());
            }
        }
    }

    private boolean skipPackaging(String ... packagings) {
        String projectPackaging = this.project.getPackaging();
        return Arrays.asList(packagings).contains(projectPackaging);
    }

    private void checkDependencies(Map<String, Map<String, String>> summaryFileContent) throws ExecutionException {
        for (Artifact artifact : this.getArtifactsToProcess()) {
            Map<String, String> fileHashcodes = summaryFileContent.get(artifact.getFile().getName());
            if (fileHashcodes == null) {
                throw new ExecutionException("Artifact " + artifact + " is not in summary file content!");
            }
            for (Map.Entry<String, String> fileHashcode : fileHashcodes.entrySet()) {
                this.process(fileHashcode.getKey(), artifact, fileHashcode.getValue());
            }
        }
    }

    private void process(String algorithm, Artifact artifact, String hash) throws ExecutionException {
        File file = artifact.getFile();
        try {
            FileDigester digester = DigesterFactory.getInstance().getFileDigester(algorithm);
            String calculatedHash = digester.calculate(file);
            if (!calculatedHash.equals(hash)) {
                throw new ExecutionException("The dependency hash value '" + calculatedHash + "' of file '" + file + "' does not equal the hash value '" + hash + "' stored in the summary file!");
            }
            this.getLog().debug((CharSequence)(artifact + " (" + file + ") - " + algorithm + " : " + calculatedHash + " = " + hash));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExecutionException("Unsupported algorithm " + algorithm + ".");
        }
        catch (DigesterException e) {
            throw new ExecutionException("Unable to calculate " + algorithm + " hash for " + file.getName() + ": " + e.getMessage());
        }
    }

    private List<Artifact> getArtifactsToProcess() {
        LinkedList<Artifact> result = new LinkedList<Artifact>();
        HashSet<Artifact> allProjectModules = new HashSet<Artifact>();
        this.allModules(this.project, allProjectModules);
        Set artifacts = this.transitive ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (allProjectModules.contains(artifact) && (this.scopes != null && !this.scopes.contains(artifact.getScope()) || this.types != null && !this.types.contains(artifact.getType()))) continue;
            this.getLog().debug((CharSequence)String.format("check artifact %s", artifact));
            result.add(artifact);
        }
        return result;
    }

    private void allModules(MavenProject mavenProject, Set<Artifact> result) {
        List collectedProjects;
        if (result.contains(mavenProject.getArtifact())) {
            return;
        }
        result.add(mavenProject.getArtifact());
        ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
        if (mavenProject.hasParent()) {
            modules.add(mavenProject.getParent());
        }
        if ((collectedProjects = mavenProject.getCollectedProjects()) != null) {
            modules.addAll(collectedProjects);
        }
        for (MavenProject module : modules) {
            this.allModules(module, result);
        }
    }

    private Map<String, Map<String, String>> readSummaryFile(File outputFile) throws ExecutionException {
        ArrayList<String> algorithms = new ArrayList<String>();
        HashMap<String, Map<String, String>> filesHashcodes = new HashMap<String, Map<String, String>>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(outputFile));
            while ((line = reader.readLine()) != null) {
                if (this.isFileHeader(line)) {
                    this.readFileHeader(line, algorithms);
                    continue;
                }
                this.readDependenciesChecksums(line, algorithms, filesHashcodes);
            }
        }
        catch (IOException e) {
            try {
                throw new ExecutionException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return filesHashcodes;
    }

    private boolean isFileHeader(String line) {
        return line.startsWith("#File");
    }

    private void readFileHeader(String line, List<String> algorithms) {
        String[] split = line.split(",");
        for (int i = 1; i < split.length; ++i) {
            algorithms.add(split[i]);
        }
    }

    private void readDependenciesChecksums(String line, List<String> algorithms, Map<String, Map<String, String>> filesHashcodes) {
        String[] split = line.split(",");
        String fileName = split[0];
        HashMap<String, String> fileHashcodes = new HashMap<String, String>();
        for (int i = 1; i < split.length; ++i) {
            fileHashcodes.put(algorithms.get(i - 1), split[i]);
        }
        filesHashcodes.put(fileName, fileHashcodes);
    }
}

