/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class MappedResizeableBuffer
implements AutoCloseable {
    private long addressOffset;
    private long capacity;
    private FileChannel fileChannel;

    public MappedResizeableBuffer(FileChannel fileChannel, long offset, long initialLength) {
        this.fileChannel = fileChannel;
        this.map(offset, initialLength);
    }

    @Override
    public void close() {
        this.unmap();
    }

    private void map(long offset, long length) {
        this.capacity = length;
        this.addressOffset = IoUtil.map(this.fileChannel, FileChannel.MapMode.READ_WRITE, offset, length);
    }

    private void unmap() {
        IoUtil.unmap(this.fileChannel, this.addressOffset, this.capacity);
    }

    public void resize(long newLength) {
        if (newLength <= 0L) {
            throw new IllegalArgumentException("Length must be a positive long, but is: " + newLength);
        }
        this.unmap();
        this.map(0L, newLength);
    }

    public void wrap(long offset, long length) {
        if (offset == this.addressOffset && length == this.capacity) {
            return;
        }
        this.wrap(this.fileChannel, offset, length);
    }

    public void wrap(FileChannel fileChannel, long offset, long length) {
        this.unmap();
        this.fileChannel = fileChannel;
        this.map(offset, length);
    }

    public long addressOffset() {
        return this.addressOffset;
    }

    public void setMemory(long index, int length, byte value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        UnsafeAccess.UNSAFE.setMemory(null, this.addressOffset + index, length, value);
    }

    public long capacity() {
        return this.capacity;
    }

    public void checkLimit(long limit) {
        if (limit > this.capacity) {
            String msg = String.format("limit=%d is beyond capacity=%d", limit, this.capacity);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public void verifyAlignment() {
        if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException(String.format("AtomicBuffer is not correctly aligned: addressOffset=%d in not divisible by %d", this.addressOffset, 8));
        }
    }

    public long getLong(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    public void putLong(long index, long value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + index, bits);
    }

    public long getLong(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + index);
    }

    public void putLong(long index, long value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + index, value);
    }

    public long getLongVolatile(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(null, this.addressOffset + index);
    }

    public void putLongVolatile(long index, long value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(null, this.addressOffset + index, value);
    }

    public void putLongOrdered(long index, long value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(null, this.addressOffset + index, value);
    }

    public long addLongOrdered(long index, long increment) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long offset = this.addressOffset + index;
        long value = UnsafeAccess.UNSAFE.getLong(null, offset);
        UnsafeAccess.UNSAFE.putOrderedLong(null, offset, value + increment);
        return value;
    }

    public boolean compareAndSetLong(long index, long expectedValue, long updateValue) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(null, this.addressOffset + index, expectedValue, updateValue);
    }

    public long getAndSetLong(long index, long value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(null, this.addressOffset + index, value);
    }

    public long getAndAddLong(long index, long delta) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(null, this.addressOffset + index, delta);
    }

    public int getInt(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    public void putInt(long index, int value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + index, bits);
    }

    public int getInt(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + index);
    }

    public void putInt(long index, int value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + index, value);
    }

    public int getIntVolatile(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(null, this.addressOffset + index);
    }

    public void putIntVolatile(long index, int value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(null, this.addressOffset + index, value);
    }

    public void putIntOrdered(long index, int value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(null, this.addressOffset + index, value);
    }

    public int addIntOrdered(long index, int increment) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        long offset = this.addressOffset + index;
        int value = UnsafeAccess.UNSAFE.getInt(null, offset);
        UnsafeAccess.UNSAFE.putOrderedInt(null, offset, value + increment);
        return value;
    }

    public boolean compareAndSetInt(long index, int expectedValue, int updateValue) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(null, this.addressOffset + index, expectedValue, updateValue);
    }

    public int getAndSetInt(long index, int value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(null, this.addressOffset + index, value);
    }

    public int getAndAddInt(long index, int delta) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(null, this.addressOffset + index, delta);
    }

    public double getDouble(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(null, this.addressOffset + index);
    }

    public void putDouble(long index, double value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(null, this.addressOffset + index, value);
        }
    }

    public double getDouble(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(null, this.addressOffset + index);
    }

    public void putDouble(long index, double value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putDouble(null, this.addressOffset + index, value);
    }

    public float getFloat(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(null, this.addressOffset + index);
    }

    public void putFloat(long index, float value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(null, this.addressOffset + index, value);
        }
    }

    public float getFloat(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(null, this.addressOffset + index);
    }

    public void putFloat(long index, float value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putFloat(null, this.addressOffset + index, value);
    }

    public short getShort(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = UnsafeAccess.UNSAFE.getShort(null, this.addressOffset + index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    public void putShort(long index, short value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(null, this.addressOffset + index, bits);
    }

    public short getShort(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(null, this.addressOffset + index);
    }

    public void putShort(long index, short value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShort(null, this.addressOffset + index, value);
    }

    public short getShortVolatile(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(null, this.addressOffset + index);
    }

    public void putShortVolatile(long index, short value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(null, this.addressOffset + index, value);
    }

    public byte getByte(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByte(null, this.addressOffset + index);
    }

    public void putByte(long index, byte value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByte(null, this.addressOffset + index, value);
    }

    public byte getByteVolatile(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(null, this.addressOffset + index);
    }

    public void putByteVolatile(long index, byte value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(null, this.addressOffset + index, value);
    }

    public void getBytes(long index, byte[] dst) {
        this.getBytes(index, dst, 0L, dst.length);
    }

    public void getBytes(long index, byte[] dst, long offset, int length) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dst, offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(null, this.addressOffset + index, dst, BufferUtil.ARRAY_BASE_OFFSET + offset, length);
    }

    public void getBytes(long index, ByteBuffer dstBuffer, int length) {
        long dstBaseOffset;
        byte[] dstnull;
        int dstOffset = dstBuffer.position();
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        }
        if (dstBuffer.hasArray()) {
            dstnull = dstBuffer.array();
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstnull = null;
            dstBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)dstBuffer)).address();
        }
        UnsafeAccess.UNSAFE.copyMemory(null, this.addressOffset + index, dstnull, dstBaseOffset + (long)dstOffset, length);
        dstBuffer.position(dstBuffer.position() + length);
    }

    public void putBytes(long index, byte[] src) {
        this.putBytes(index, src, 0L, src.length);
    }

    public void putBytes(long index, byte[] src, long offset, int length) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(src, offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET + offset, null, this.addressOffset + index, length);
    }

    public void putBytes(long index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        }
        this.putBytes(index, srcBuffer, (long)srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    public void putBytes(long index, ByteBuffer srcBuffer, long srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcnull;
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(srcBuffer, srcIndex, length);
        }
        if (srcBuffer.hasArray()) {
            srcnull = srcBuffer.array();
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)srcBuffer.arrayOffset();
        } else {
            srcnull = null;
            srcBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)srcBuffer)).address();
        }
        UnsafeAccess.UNSAFE.copyMemory(srcnull, srcBaseOffset + srcIndex, null, this.addressOffset + index, length);
    }

    public void putBytes(long index, DirectBuffer srcBuffer, int srcIndex, int length) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            srcBuffer.boundsCheck(srcIndex, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(null, srcBuffer.addressOffset() + (long)srcIndex, null, this.addressOffset + index, length);
    }

    public char getChar(long index, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = UnsafeAccess.UNSAFE.getChar(null, this.addressOffset + index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    public void putChar(long index, char value, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(null, this.addressOffset + index, bits);
    }

    public char getChar(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(null, this.addressOffset + index);
    }

    public void putChar(long index, char value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putChar(null, this.addressOffset + index, value);
    }

    public char getCharVolatile(long index) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(null, this.addressOffset + index);
    }

    public void putCharVolatile(long index, char value) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(null, this.addressOffset + index, value);
    }

    public String getStringUtf8(long offset) {
        int length = this.getInt(offset);
        return this.getStringUtf8(offset, length);
    }

    public String getStringUtf8(long offset, ByteOrder byteOrder) {
        int length = this.getInt(offset, byteOrder);
        return this.getStringUtf8(offset, length);
    }

    public String getStringUtf8(long offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset + 4L, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    public int putStringUtf8(long offset, String value) {
        return this.putStringUtf8(offset, value, Integer.MAX_VALUE);
    }

    public int putStringUtf8(long offset, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(offset, value, byteOrder, Integer.MAX_VALUE);
    }

    public int putStringUtf8(long offset, String value, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(offset, bytes.length);
        this.putBytes(offset + 4L, bytes);
        return 4 + bytes.length;
    }

    public int putStringUtf8(long offset, String value, ByteOrder byteOrder, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(offset, bytes.length, byteOrder);
        this.putBytes(offset + 4L, bytes);
        return 4 + bytes.length;
    }

    public String getStringWithoutLengthUtf8(long offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    public int putStringWithoutLengthUtf8(long offset, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.putBytes(offset, bytes);
        return bytes.length;
    }

    public void boundsCheck(long index, int length) {
        this.boundsCheck0(index, length);
    }

    private void boundsCheck(long index) {
        if (index < 0L || index >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, capacity=%d", index, this.capacity));
        }
    }

    private void boundsCheck0(long index, int length) {
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > this.capacity || resultingPosition < index) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, this.capacity));
        }
    }
}

