/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-dep-version", threadSafe=true)
public class UseDepVersionMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="depVersion", required=true)
    protected String depVersion;
    @Parameter(property="forceVersion", defaultValue="false")
    protected boolean forceVersion;

    @Inject
    public UseDepVersionMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        if (this.depVersion == null || this.depVersion.equals("")) {
            throw new IllegalArgumentException("depVersion must be supplied with use-specific-version, and cannot be blank.");
        }
        if (!this.forceVersion && !this.hasIncludes()) {
            throw new IllegalArgumentException("The use-specific-version goal is intended to be used with a single artifact. Please specify a value for the 'includes' parameter, or use -DforceVersion=true to override this check.");
        }
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useDepVersion(pom, dependencyManagement.getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useDepVersion(pom, this.getProject().getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useDepVersion(pom, Collections.singletonList(this.getParentDependency()), ChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useDepVersion(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, ChangeRecord.ChangeKind changeKind) throws MojoExecutionException, XMLStreamException, VersionRetrievalException {
        for (Dependency dep : dependencies) {
            ArtifactVersions versions;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            if (!this.forceVersion && !(versions = this.getHelper().lookupArtifactVersions(artifact, false)).containsVersion(this.depVersion)) {
                throw new MojoExecutionException(String.format("Version %s is not available for artifact %s:%s", this.depVersion, artifact.getGroupId(), artifact.getArtifactId()));
            }
            this.updateDependencyVersion(pom, dep, this.depVersion, changeKind);
        }
    }
}

