/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.logging;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.eluder.coveralls.maven.plugin.logging.Logger;

public class DryRunLogger
implements Logger {
    private final boolean dryRun;
    private final File coverallsFile;

    public DryRunLogger(boolean dryRun, File coverallsFile) {
        if (coverallsFile == null) {
            throw new IllegalArgumentException("coverallsFile must be defined");
        }
        this.dryRun = dryRun;
        this.coverallsFile = coverallsFile;
    }

    @Override
    public Logger.Position getPosition() {
        return Logger.Position.AFTER;
    }

    @Override
    public void log(Log log) {
        if (this.dryRun) {
            log.info((CharSequence)"Dry run enabled, Coveralls report will NOT be submitted to API");
            log.info((CharSequence)(this.coverallsFile.length() + " bytes of data was recorded in " + this.coverallsFile.getAbsolutePath()));
        }
    }
}

