/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eluder.coveralls.maven.plugin.CoverageParser;
import org.eluder.coveralls.maven.plugin.parser.AbstractXmlEventParser;
import org.eluder.coveralls.maven.plugin.parser.CoberturaParser;
import org.eluder.coveralls.maven.plugin.parser.JaCoCoParser;
import org.eluder.coveralls.maven.plugin.parser.SagaParser;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;
import org.eluder.coveralls.maven.plugin.util.ExistingFiles;
import org.eluder.coveralls.maven.plugin.util.MavenProjectCollector;

public class CoverageParsersFactory {
    private static final String JACOCO_FILE = "/jacoco.xml";
    private static final String JACOCO_PREFIX = "/jacoco";
    private static final String JACOCO_IT_PREFIX = "/jacoco-it";
    private static final String COBERTURA_FILE = "/coverage.xml";
    private static final String COBERTURA_PREFIX = "/cobertura";
    private static final String SAGA_FILE = "/total-coverage.xml";
    private static final String SAGA_PREFIX = "/saga-coverage";
    private final MavenProject project;
    private final SourceLoader sourceLoader;
    private List<File> jacocoReports;
    private List<File> coberturaReports;
    private List<File> sagaReports;
    private List<String> relativeReportDirs;

    public CoverageParsersFactory(MavenProject project, SourceLoader sourceLoader) {
        this.project = project;
        this.sourceLoader = sourceLoader;
    }

    public CoverageParsersFactory withJaCoCoReports(List<File> jacocoReports) {
        this.jacocoReports = jacocoReports;
        return this;
    }

    public CoverageParsersFactory withCoberturaReports(List<File> coberturaReports) {
        this.coberturaReports = coberturaReports;
        return this;
    }

    public CoverageParsersFactory withSagaReports(List<File> sagaReports) {
        this.sagaReports = sagaReports;
        return this;
    }

    public CoverageParsersFactory withRelativeReportDirs(List<String> relativeReportDirs) {
        this.relativeReportDirs = relativeReportDirs;
        return this;
    }

    public List<CoverageParser> createParsers() throws IOException {
        ArrayList<AbstractXmlEventParser> parsers = new ArrayList<AbstractXmlEventParser>();
        List<MavenProject> projects = new MavenProjectCollector(this.project).collect();
        ExistingFiles jacocoFiles = ExistingFiles.create(this.jacocoReports);
        ExistingFiles coberturaFiles = ExistingFiles.create(this.coberturaReports);
        ExistingFiles sagaFiles = ExistingFiles.create(this.sagaReports);
        for (MavenProject p : projects) {
            File reportingDirectory = new File(p.getModel().getReporting().getOutputDirectory());
            File buildDirectory = new File(p.getBuild().getDirectory());
            jacocoFiles.add(new File(reportingDirectory, "/jacoco/jacoco.xml"));
            jacocoFiles.add(new File(reportingDirectory, "/jacoco-it/jacoco.xml"));
            coberturaFiles.add(new File(reportingDirectory, "/cobertura/coverage.xml"));
            sagaFiles.add(new File(buildDirectory, "/saga-coverage/total-coverage.xml"));
            if (this.relativeReportDirs == null) continue;
            for (String relativeReportPath : this.relativeReportDirs) {
                File relativeReportingDirectory = reportingDirectory;
                File relativeBuildDirectory = buildDirectory;
                if (!relativeReportPath.isEmpty() && !File.separator.equals(relativeReportPath)) {
                    relativeReportingDirectory = new File(reportingDirectory, relativeReportPath);
                    relativeBuildDirectory = new File(buildDirectory, relativeReportPath);
                }
                jacocoFiles.add(new File(relativeReportingDirectory, JACOCO_FILE));
                jacocoFiles.add(new File(relativeBuildDirectory, JACOCO_FILE));
                coberturaFiles.add(new File(relativeReportingDirectory, COBERTURA_FILE));
                coberturaFiles.add(new File(relativeBuildDirectory, COBERTURA_FILE));
                sagaFiles.add(new File(relativeReportingDirectory, SAGA_FILE));
                sagaFiles.add(new File(relativeBuildDirectory, SAGA_FILE));
            }
        }
        for (File jacocoFile : jacocoFiles) {
            parsers.add(new JaCoCoParser(jacocoFile, this.sourceLoader));
        }
        for (File coberturaFile : coberturaFiles) {
            parsers.add(new CoberturaParser(coberturaFile, this.sourceLoader));
        }
        for (File sagaFile : sagaFiles) {
            parsers.add(new SagaParser(sagaFile, this.sourceLoader));
        }
        if (parsers.isEmpty()) {
            throw new IOException("No coverage report files found");
        }
        return Collections.unmodifiableList(parsers);
    }
}

