/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.builders.node;

import org.neo4j.ogm.compiler.RelationshipBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.response.model.PropertyModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public class DefaultRelationshipBuilder
implements RelationshipBuilder {
    RelationshipModel relationship = new RelationshipModel();
    private String direction;
    private boolean singleton = true;
    private boolean bidirectional = false;
    private boolean relationshipEntity = false;

    public DefaultRelationshipBuilder(String type, boolean bidirectional) {
        this.relationship.setType(type);
        this.relationship.setId(Long.valueOf(-System.identityHashCode(this.relationship)));
        this.bidirectional = bidirectional;
    }

    public DefaultRelationshipBuilder(String type, Long relationshipId) {
        if (relationshipId == null) {
            relationshipId = -System.identityHashCode(this.relationship);
        }
        this.relationship.setId(relationshipId);
        this.relationship.setType(type);
    }

    public Long reference() {
        return this.relationship.getId();
    }

    public void setType(String type) {
        this.relationship.setType(type);
    }

    public void addProperty(String key, Object value) {
        this.relationship.getPropertyList().add(new PropertyModel((Object)key, value));
    }

    public void relate(Long startNodeId, Long endNodeId) {
        this.relationship.setStartNode(startNodeId);
        this.relationship.setEndNode(endNodeId);
    }

    public String type() {
        return this.relationship.getType();
    }

    public boolean hasDirection(String direction) {
        return this.direction != null && this.direction.equals(direction);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isNew() {
        return true;
    }

    public void setSingleton(boolean b) {
        this.singleton = b;
    }

    public boolean isRelationshipEntity() {
        return this.relationshipEntity;
    }

    public void setRelationshipEntity(boolean relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
    }

    public RelationshipBuilder direction(String direction) {
        this.direction = direction;
        return this;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public Edge edge() {
        return this.relationship;
    }

    public void setReference(Long reference) {
        this.relationship.setId(reference);
    }
}

