/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import org.specs.Specification;
import org.specs.execute.FailureException;
import org.specs.execute.HasResults;
import org.specs.execute.SkippedException;
import org.specs.runner.AnsiColors$;
import org.specs.runner.OutputReporter;
import org.specs.runner.OutputReporter$;
import org.specs.specification.Example;
import org.specs.specification.Examples;
import org.specs.specification.Sus;
import org.specs.util.ExtendedThrowable$;
import org.specs.util.Plural$;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Predef$;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public abstract class OutputReporter$class {
    public static void $init$(OutputReporter $this) {
    }

    public static final String errorType$1(OutputReporter $this, Throwable t2) {
        Throwable throwable = t2;
        return throwable instanceof SkippedException ? "" : (throwable instanceof FailureException ? "" : new StringBuilder().append((Object)throwable.getClass().getName()).append((Object)": ").toString());
    }

    public static final String parens$1(OutputReporter $this, Throwable f2) {
        return new StringBuilder().append((Object)" (").append((Object)ExtendedThrowable$.MODULE$.toExtendedThrowable(f2).location()).append((Object)")").toString();
    }

    private static final String status$1(OutputReporter $this, Examples example) {
        return BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) ? $this.infoColored("-") : (example.hasFailureOrErrors() ? $this.failureColored("x") : (example.skipped().size() > 0 ? $this.skipColored("o") : $this.successColored("+")));
    }

    private static final String failureColoredIf$1(OutputReporter $this, String text, boolean cond) {
        return cond ? $this.failureColored(text) : text;
    }

    public static final void displaySus$1(OutputReporter $this, Sus s2, Iterable iterable, String string) {
        if (iterable.toList().size() > 1) {
            $this.reportSus(s2, string);
        } else {
            $this.printSus(s2, string);
        }
    }

    public static final boolean org$specs$runner$OutputReporter$$canReport(OutputReporter $this, HasResults hasResults) {
        return !BoxesRunTime.unboxToBoolean((Object)$this.failedAndErrorsOnly().apply()) || BoxesRunTime.unboxToBoolean((Object)$this.failedAndErrorsOnly().apply()) && hasResults.hasFailureOrErrors();
    }

    public static void reportExample(OutputReporter $this, Examples example, String padding$3) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) || OutputReporter$class.org$specs$runner$OutputReporter$$canReport($this, example)) {
            $this.println(new StringBuilder().append((Object)padding$3).append((Object)OutputReporter$class.status$1($this, example)).append((Object)" ").append((Object)example.description()).toString());
        }
        if (!BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) && example.examples().isEmpty()) {
            List list = example.skipped().toList();
            List list2 = example.failures().toList();
            example.errors().toList().$colon$colon$colon(list2).$colon$colon$colon(list).foreach((Function1)new OutputReporter$.anonfun.reportExample.1($this, padding$3));
            if (BoxesRunTime.unboxToBoolean((Object)$this.stacktrace().apply()) && example.errors().size() > 0) {
                example.errors().foreach((Function1)new OutputReporter$.anonfun.reportExample.2($this));
            }
        }
    }

    public static void reportExamples(OutputReporter $this, Iterable examples2, String padding$4) {
        examples2.foreach((Function1)new OutputReporter$.anonfun.reportExamples.1($this, padding$4));
    }

    public static void printStats(OutputReporter $this, Tuple5 stat, String padding) {
        Tuple5 tuple5 = stat;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Tuple5 tuple52 = new Tuple5(tuple5._1(), tuple5._2(), tuple5._3(), tuple5._4(), tuple5._5());
        int examplesNb = BoxesRunTime.unboxToInt((Object)tuple52._1());
        int expectationsNb2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
        int failuresNb = BoxesRunTime.unboxToInt((Object)tuple52._3());
        int errorsNb = BoxesRunTime.unboxToInt((Object)tuple52._4());
        int skippedNb = BoxesRunTime.unboxToInt((Object)tuple52._5());
        $this.println(new StringBuilder().append((Object)padding).append((Object)"Finished in ").append((Object)$this.timer().time()).toString());
        $this.println(new StringBuilder().append((Object)padding).append((Object)BoxesRunTime.boxToInteger((int)examplesNb)).append((Object)Plural$.MODULE$.stringToPlural(" example").plural(examplesNb)).append((Object)(skippedNb > 0 ? new StringBuilder().append((Object)" (").append((Object)BoxesRunTime.boxToInteger((int)skippedNb)).append((Object)" skipped)").toString() : "")).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)expectationsNb2)).append((Object)Plural$.MODULE$.stringToPlural(" expectation").plural(expectationsNb2)).append((Object)", ").append((Object)OutputReporter$class.failureColoredIf$1($this, new StringBuilder().append(failuresNb).append((Object)Plural$.MODULE$.stringToPlural(" failure").plural(failuresNb)).toString(), failuresNb > 0)).append((Object)", ").append((Object)OutputReporter$class.failureColoredIf$1($this, new StringBuilder().append(errorsNb).append((Object)Plural$.MODULE$.stringToPlural(" error").plural(errorsNb)).toString(), errorsNb > 0)).toString());
        $this.println("");
    }

    public static void printStats(OutputReporter $this, Sus sus, String padding) {
        $this.println(new StringBuilder().append((Object)padding).append((Object)"Total for SUS \"").append((Object)sus.description()).append((Object)"\":").toString());
        $this.printStats($this.stats(sus), padding);
    }

    public static void printSus(OutputReporter $this, Sus sus, String padding) {
        String susDescription;
        String string = susDescription = sus.isAnonymous() ? "" : new StringBuilder().append((Object)sus.description()).append((Object)" ").append((Object)sus.verb()).toString();
        if (sus.literateDesc().isEmpty()) {
            $this.println(new StringBuilder().append((Object)padding).append((Object)susDescription).toString());
        } else {
            $this.println(new StringBuilder().append((Object)padding).append((Object)sus.literateDescText()).toString());
        }
        $this.timer().start();
        if (!BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) && sus.hasOwnFailureOrErrors()) {
            $this.reportExample(sus, padding);
        }
        $this.reportExamples((Iterable<Example>)sus.examples(), padding);
        $this.timer().stop();
        $this.println("");
    }

    public static void reportSus(OutputReporter $this, Sus sus, String padding) {
        $this.printSus(sus, padding);
        if (BoxesRunTime.unboxToBoolean((Object)$this.statistics().apply()) && !BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) && !sus.examples().isEmpty()) {
            $this.printStats(sus, padding);
        }
    }

    public static void reportSystems(OutputReporter $this, Iterable systems$1, String padding$2) {
        systems$1.foreach((Function1)new OutputReporter$.anonfun.reportSystems.1($this, systems$1, padding$2));
    }

    public static Tuple5 stats(OutputReporter $this, Example example) {
        return BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) ? new Tuple5<Integer, Integer, Integer, Integer, Integer>((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)) : $this.toAddableTuple((Tuple5<Integer, Integer, Integer, Integer, Integer>)new Tuple5((Object)(example.examples().isEmpty() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)example.ownExpectationsNb()), (Object)BoxesRunTime.boxToInteger((int)example.ownFailures().size()), (Object)BoxesRunTime.boxToInteger((int)example.ownErrors().size()), (Object)BoxesRunTime.boxToInteger((int)example.ownSkipped().size()))).$plus((Tuple5<Integer, Integer, Integer, Integer, Integer>)((Tuple5)example.examples().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.4($this))));
    }

    public static Tuple5 stats(OutputReporter $this, Sus sus) {
        return (Tuple5)sus.examples().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.3($this));
    }

    public static Tuple5 stats(OutputReporter $this, Specification spec) {
        return $this.toAddableTuple((Tuple5<Integer, Integer, Integer, Integer, Integer>)((Tuple5)spec.systems().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.1($this)))).$plus((Tuple5<Integer, Integer, Integer, Integer, Integer>)((Tuple5)spec.subSpecifications().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.2($this))));
    }

    public static OutputReporter.AddableTuple toAddableTuple(OutputReporter $this, Tuple5 t1) {
        return new OutputReporter.AddableTuple($this, (Tuple5<Integer, Integer, Integer, Integer, Integer>)t1);
    }

    public static OutputReporter reportSpec(OutputReporter $this, Specification spec, String padding) {
        $this.timer().start();
        $this.println(new StringBuilder().append((Object)padding).append((Object)"Specification \"").append((Object)spec.name()).append((Object)"\"").toString());
        $this.report((Seq<Specification>)spec.subSpecifications(), new StringBuilder().append((Object)padding).append((Object)"  ").toString());
        $this.reportSystems((Iterable<Sus>)spec.systems(), new StringBuilder().append((Object)padding).append((Object)"  ").toString());
        $this.timer().stop();
        boolean isFirstSpecification = Predef$.MODULE$.stringWrapper(padding).isEmpty();
        if (BoxesRunTime.unboxToBoolean((Object)$this.statistics().apply()) && (!BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) || BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) && isFirstSpecification)) {
            $this.println(new StringBuilder().append((Object)padding).append((Object)"Total for specification \"").append((Object)spec.name()).append((Object)"\":").toString());
            $this.printStats($this.stats(spec), padding);
        }
        return $this;
    }

    public static OutputReporter report(OutputReporter $this, Seq specs, String padding$1) {
        specs.foreach((Function1)new OutputReporter$.anonfun.report.1($this, padding$1));
        return $this;
    }

    public static OutputReporter report(OutputReporter $this, Seq specs) {
        $this.org$specs$runner$OutputReporter$$super$report(specs);
        return $this.report((Seq<Specification>)specs, "");
    }

    public static String infoColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.blue()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String skipColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.yellow()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String successColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.green()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String failureColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.red()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }
}

