/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.support.postprocessor.GUnzipPostProcessor;
import org.springframework.amqp.support.postprocessor.InflaterPostProcessor;
import org.springframework.amqp.support.postprocessor.UnzipPostProcessor;
import org.springframework.core.Ordered;

public class DelegatingDecompressingPostProcessor
implements MessagePostProcessor,
Ordered {
    private final Map<String, MessagePostProcessor> decompressors = new HashMap<String, MessagePostProcessor>();
    private int order;

    public DelegatingDecompressingPostProcessor() {
        this.decompressors.put("gzip", new GUnzipPostProcessor());
        this.decompressors.put("zip", new UnzipPostProcessor());
        this.decompressors.put("deflate", new InflaterPostProcessor());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void addDecompressor(String contentEncoding, MessagePostProcessor decompressor) {
        this.decompressors.put(contentEncoding, decompressor);
    }

    public MessagePostProcessor removeDecompressor(String contentEncoding) {
        return this.decompressors.remove(contentEncoding);
    }

    public void setDecompressors(Map<String, MessagePostProcessor> decompressors) {
        this.decompressors.clear();
        this.decompressors.putAll(decompressors);
    }

    @Override
    public Message postProcessMessage(Message message) throws AmqpException {
        MessagePostProcessor decompressor;
        String encoding = message.getMessageProperties().getContentEncoding();
        if (encoding == null) {
            return message;
        }
        int delimAt = encoding.indexOf(58);
        if (delimAt < 0) {
            delimAt = encoding.indexOf(44);
        }
        if (delimAt > 0) {
            encoding = encoding.substring(0, delimAt);
        }
        if ((decompressor = this.decompressors.get(encoding)) != null) {
            return decompressor.postProcessMessage(message);
        }
        return message;
    }
}

