/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.client.discovery.DiscoveryLifecycle;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

@Deprecated
public abstract class AbstractDiscoveryLifecycle
implements DiscoveryLifecycle,
ApplicationContextAware,
ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private static final Log logger = LogFactory.getLog(AbstractDiscoveryLifecycle.class);
    private boolean autoStartup = true;
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private ApplicationContext context;
    private Environment environment;
    private AtomicInteger port = new AtomicInteger(0);

    protected ApplicationContext getContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.environment = this.context.getEnvironment();
    }

    @Deprecated
    protected Environment getEnvironment() {
        return this.environment;
    }

    @Deprecated
    protected AtomicInteger getPort() {
        return this.port;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error((Object)"A problem occurred attempting to stop discovery lifecycle", (Throwable)e);
        }
        callback.run();
    }

    public void start() {
        if (!this.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Discovery Lifecycle disabled. Not starting");
            }
            return;
        }
        if (this.port.get() != 0 && this.getConfiguredPort() == 0) {
            this.setConfiguredPort(this.port.get());
        }
        if (!this.running.get() && this.getConfiguredPort() > 0) {
            this.register();
            if (this.shouldRegisterManagement()) {
                this.registerManagement();
            }
            this.context.publishEvent(new InstanceRegisteredEvent<Object>(this, this.getConfiguration()));
            this.running.compareAndSet(false, true);
        }
    }

    @Deprecated
    protected abstract int getConfiguredPort();

    @Deprecated
    protected abstract void setConfiguredPort(int var1);

    protected boolean shouldRegisterManagement() {
        return this.getManagementPort() != null && ManagementServerPortUtils.isDifferent((BeanFactory)this.context);
    }

    @Deprecated
    protected abstract Object getConfiguration();

    protected abstract void register();

    protected void registerManagement() {
    }

    protected abstract void deregister();

    protected void deregisterManagement() {
    }

    protected abstract boolean isEnabled();

    @Deprecated
    protected String getManagementServiceId() {
        return this.context.getId() + ":management";
    }

    @Deprecated
    protected String getManagementServiceName() {
        return this.getAppName() + ":management";
    }

    @Deprecated
    protected Integer getManagementPort() {
        return ManagementServerPortUtils.getPort((BeanFactory)this.context);
    }

    @Deprecated
    protected String getAppName() {
        return this.environment.getProperty("spring.application.name", "application");
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.isEnabled()) {
            this.deregister();
            if (this.shouldRegisterManagement()) {
                this.deregisterManagement();
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected AtomicBoolean getRunning() {
        return this.running;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPhase() {
        return 0;
    }

    @Deprecated
    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        if (!"management".equals(event.getApplicationContext().getNamespace())) {
            this.port.compareAndSet(0, event.getEmbeddedServletContainer().getPort());
            this.start();
        }
    }
}

