/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.Dimensional;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.core.query.WithConsistency;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.StringUtils;

public class CouchbaseQueryMethod
extends QueryMethod {
    private final Method method;

    public CouchbaseQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        super(method, metadata, factory);
        this.method = method;
    }

    public boolean hasViewAnnotation() {
        return this.getViewAnnotation() != null;
    }

    public boolean hasViewSpecification() {
        return this.hasDesignDoc() && this.hasViewName();
    }

    public boolean hasDesignDoc() {
        View annotation = this.getViewAnnotation();
        if (annotation == null) {
            return false;
        }
        return StringUtils.hasText((String)annotation.designDocument());
    }

    public boolean hasViewName() {
        View annotation = this.getViewAnnotation();
        if (annotation == null) {
            return false;
        }
        return StringUtils.hasText((String)annotation.viewName());
    }

    public View getViewAnnotation() {
        return this.method.getAnnotation(View.class);
    }

    public boolean hasDimensionalAnnotation() {
        return this.getDimensionalAnnotation() != null;
    }

    public Dimensional getDimensionalAnnotation() {
        return (Dimensional)AnnotationUtils.findAnnotation((Method)this.method, Dimensional.class);
    }

    public boolean hasN1qlAnnotation() {
        return this.getN1qlAnnotation() != null;
    }

    public Query getN1qlAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    public boolean hasInlineN1qlQuery() {
        return this.getInlineN1qlQuery() != null;
    }

    public boolean hasConsistencyAnnotation() {
        return this.getConsistencyAnnotation() != null;
    }

    public WithConsistency getConsistencyAnnotation() {
        return this.method.getAnnotation(WithConsistency.class);
    }

    public String getInlineN1qlQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getN1qlAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    public String toString() {
        return super.toString();
    }
}

