/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.lang.Nullable;

class DefaultBoundValueOperations<K, V>
extends DefaultBoundKeyOperations<K>
implements BoundValueOperations<K, V> {
    private final ValueOperations<K, V> ops;

    DefaultBoundValueOperations(K key, RedisOperations<K, V> operations) {
        super(key, operations);
        this.ops = operations.opsForValue();
    }

    @Override
    public V get() {
        return this.ops.get(this.getKey());
    }

    @Override
    public V getAndSet(V value) {
        return this.ops.getAndSet(this.getKey(), value);
    }

    @Override
    public Long increment() {
        return this.ops.increment(this.getKey());
    }

    @Override
    public Long increment(long delta) {
        return this.ops.increment(this.getKey(), delta);
    }

    @Override
    public Double increment(double delta) {
        return this.ops.increment(this.getKey(), delta);
    }

    @Override
    public Long decrement() {
        return this.ops.decrement(this.getKey());
    }

    @Override
    public Long decrement(long delta) {
        return this.ops.decrement(this.getKey(), delta);
    }

    @Override
    public Integer append(String value) {
        return this.ops.append(this.getKey(), value);
    }

    @Override
    public String get(long start, long end) {
        return this.ops.get(this.getKey(), start, end);
    }

    @Override
    public void set(V value, long timeout, TimeUnit unit) {
        this.ops.set(this.getKey(), value, timeout, unit);
    }

    @Override
    public void set(V value) {
        this.ops.set(this.getKey(), value);
    }

    @Override
    public Boolean setIfAbsent(V value) {
        return this.ops.setIfAbsent(this.getKey(), value);
    }

    @Override
    public Boolean setIfAbsent(V value, long timeout, TimeUnit unit) {
        return this.ops.setIfAbsent(this.getKey(), value, timeout, unit);
    }

    @Override
    @Nullable
    public Boolean setIfPresent(V value) {
        return this.ops.setIfPresent(this.getKey(), value);
    }

    @Override
    @Nullable
    public Boolean setIfPresent(V value, long timeout, TimeUnit unit) {
        return this.ops.setIfPresent(this.getKey(), value, timeout, unit);
    }

    @Override
    public void set(V value, long offset) {
        this.ops.set(this.getKey(), value, offset);
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public RedisOperations<K, V> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }
}

