/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    private FileOutputStream mFos;
    private File mFile;
    private boolean mAppend;
    private boolean mAlwaysCreate;
    private boolean mOpened = false;
    private boolean mClosed = false;

    public LazyFileOutputStream(String name) {
        this(name, false);
    }

    public LazyFileOutputStream(String name, boolean append) {
        this(new File(name), append);
    }

    public LazyFileOutputStream(File f) {
        this(f, false);
    }

    public LazyFileOutputStream(File file, boolean append) {
        this(file, append, false);
    }

    public LazyFileOutputStream(File file, boolean append, boolean alwaysCreate) {
        this.mFile = file;
        this.mAppend = append;
        this.mAlwaysCreate = alwaysCreate;
    }

    public void open() throws IOException {
        this.ensureOpened();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mAlwaysCreate && !this.mClosed) {
            this.ensureOpened();
        }
        if (this.mOpened) {
            this.mFos.close();
        }
        this.mClosed = true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int offset, int len) throws IOException {
        this.ensureOpened();
        this.mFos.write(b, offset, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensureOpened();
        this.mFos.write(b);
    }

    private synchronized void ensureOpened() throws IOException {
        if (this.mClosed) {
            throw new IOException(this.mFile + " has already been closed.");
        }
        if (!this.mOpened) {
            this.mFos = new FileOutputStream(this.mFile.getAbsolutePath(), this.mAppend);
            this.mOpened = true;
        }
    }
}

