/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import com.google.common.base.Preconditions;
import tachyon.conf.WorkerConf;

public class UserInfo {
    private final long mUserId;
    private long mLastHeartbeatMs;

    public UserInfo(long userId) {
        Preconditions.checkArgument((userId > 0L ? 1 : 0) != 0, (Object)("Invalid user id " + userId));
        this.mUserId = userId;
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public long getUserId() {
        return this.mUserId;
    }

    public synchronized void heartbeat() {
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public synchronized boolean timeout() {
        return System.currentTimeMillis() - this.mLastHeartbeatMs > (long)WorkerConf.get().USER_TIMEOUT_MS;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("UserInfo(");
        sb.append(" mUserId: ").append(this.mUserId);
        sb.append(", mLastHeartbeatMs: ").append(this.mLastHeartbeatMs);
        sb.append(")");
        return sb.toString();
    }
}

