/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import tachyon.client.BlockInStream;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFile;

public class FileInStream
extends InStream {
    private final long mFileLength;
    private final long mBlockCapacity;
    private long mCurrentPosition;
    private int mCurrentBlockIndex;
    private BlockInStream mCurrentBlockInStream;
    private long mCurrentBlockLeft;
    private boolean mClosed = false;
    private Object mUFSConf = null;

    public FileInStream(TachyonFile file, ReadType opType) throws IOException {
        this(file, opType, null);
    }

    public FileInStream(TachyonFile file, ReadType opType, Object ufsConf) throws IOException {
        super(file, opType);
        this.mFileLength = file.length();
        this.mBlockCapacity = file.getBlockSizeByte();
        this.mCurrentPosition = 0L;
        this.mCurrentBlockIndex = -1;
        this.mCurrentBlockInStream = null;
        this.mCurrentBlockLeft = 0L;
        this.mUFSConf = ufsConf;
    }

    private void checkAndAdvanceBlockInStream() throws IOException {
        if (this.mCurrentBlockLeft == 0L) {
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockIndex = this.getCurrentBlockIndex();
            this.mCurrentBlockInStream = BlockInStream.get(this.mFile, this.mReadType, this.mCurrentBlockIndex, this.mUFSConf);
            this.mCurrentBlockLeft = this.mBlockCapacity;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed && this.mCurrentBlockInStream != null) {
            this.mCurrentBlockInStream.close();
        }
        this.mClosed = true;
    }

    private int getCurrentBlockIndex() {
        return (int)(this.mCurrentPosition / this.mBlockCapacity);
    }

    @Override
    public int read() throws IOException {
        if (this.mCurrentPosition >= this.mFileLength) {
            return -1;
        }
        this.checkAndAdvanceBlockInStream();
        ++this.mCurrentPosition;
        --this.mCurrentBlockLeft;
        return this.mCurrentBlockInStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.mCurrentPosition >= this.mFileLength) {
            return -1;
        }
        int tOff = off;
        int tLen = len;
        while (tLen > 0 && this.mCurrentPosition < this.mFileLength) {
            this.checkAndAdvanceBlockInStream();
            int tRead = this.mCurrentBlockInStream.read(b, tOff, tLen);
            if (tRead == -1) continue;
            this.mCurrentPosition += (long)tRead;
            this.mCurrentBlockLeft -= (long)tRead;
            tLen -= tRead;
            tOff += tRead;
        }
        return len - tLen;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.mCurrentPosition == pos) {
            return;
        }
        if (pos < 0L) {
            throw new IOException("Seek position is negative: " + pos);
        }
        if (pos > this.mFileLength) {
            throw new IOException("Seek position is past EOF: " + pos + ", fileSize = " + this.mFileLength);
        }
        if ((int)(pos / this.mBlockCapacity) != this.mCurrentBlockIndex) {
            this.mCurrentBlockIndex = (int)(pos / this.mBlockCapacity);
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockInStream = BlockInStream.get(this.mFile, this.mReadType, this.mCurrentBlockIndex, this.mUFSConf);
        }
        this.mCurrentBlockInStream.seek(pos % this.mBlockCapacity);
        this.mCurrentPosition = pos;
        this.mCurrentBlockLeft = this.mBlockCapacity - pos % this.mBlockCapacity;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long ret = n;
        if (this.mCurrentPosition + n >= this.mFile.length()) {
            ret = this.mFile.length() - this.mCurrentPosition;
            this.mCurrentPosition += ret;
        } else {
            this.mCurrentPosition += n;
        }
        int tBlockIndex = (int)(this.mCurrentPosition / this.mBlockCapacity);
        if (tBlockIndex != this.mCurrentBlockIndex) {
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockIndex = tBlockIndex;
            this.mCurrentBlockInStream = BlockInStream.get(this.mFile, this.mReadType, this.mCurrentBlockIndex, this.mUFSConf);
            long shouldSkip = this.mCurrentPosition % this.mBlockCapacity;
            long skip = this.mCurrentBlockInStream.skip(shouldSkip);
            this.mCurrentBlockLeft = this.mBlockCapacity - skip;
            if (skip != shouldSkip) {
                throw new IOException("The underlayer BlockInStream only skip " + skip + " instead of " + shouldSkip);
            }
        } else {
            long skip = this.mCurrentBlockInStream.skip(ret);
            if (skip != ret) {
                throw new IOException("The underlayer BlockInStream only skip " + skip + " instead of " + ret);
            }
        }
        return ret;
    }
}

