/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.BlockOutStream;
import tachyon.client.OutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.util.CommonUtils;

public class FileOutStream
extends OutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final long mBlockCapacityByte;
    private BlockOutStream mCurrentBlockOutStream;
    private long mCurrentBlockId;
    private long mCurrentBlockLeftByte;
    private List<BlockOutStream> mPreviousBlockOutStreams;
    private long mCachedBytes;
    private OutputStream mCheckpointOutputStream = null;
    private String mUnderFsFile = null;
    private boolean mClosed = false;
    private boolean mCancel = false;

    FileOutStream(TachyonFile file, WriteType opType, Object ufsConf) throws IOException {
        super(file, opType);
        this.mBlockCapacityByte = file.getBlockSizeByte();
        this.mCurrentBlockOutStream = null;
        this.mCurrentBlockId = -1L;
        this.mCurrentBlockLeftByte = 0L;
        this.mPreviousBlockOutStreams = new ArrayList<BlockOutStream>();
        this.mCachedBytes = 0L;
        if (this.mWriteType.isThrough()) {
            this.mUnderFsFile = CommonUtils.concat(this.mTachyonFS.createAndGetUserUfsTempFolder(ufsConf), this.mFile.mFileId);
            UnderFileSystem underfsClient = UnderFileSystem.get(this.mUnderFsFile, ufsConf);
            if (this.mBlockCapacityByte > Integer.MAX_VALUE) {
                throw new IOException("BLOCK_CAPCAITY (" + this.mBlockCapacityByte + ") can not bigger than " + Integer.MAX_VALUE);
            }
            this.mCheckpointOutputStream = underfsClient.create(this.mUnderFsFile, (int)this.mBlockCapacityByte);
        }
    }

    @Override
    public void cancel() throws IOException {
        this.mCancel = true;
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (this.mCurrentBlockOutStream != null) {
                this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
            }
            Boolean canComplete = false;
            if (this.mWriteType.isThrough()) {
                if (this.mCancel) {
                    this.mCheckpointOutputStream.close();
                    UnderFileSystem underFsClient = UnderFileSystem.get(this.mUnderFsFile);
                    underFsClient.delete(this.mUnderFsFile, false);
                } else {
                    this.mCheckpointOutputStream.flush();
                    this.mCheckpointOutputStream.close();
                    this.mTachyonFS.addCheckpoint(this.mFile.mFileId);
                    canComplete = true;
                }
            }
            if (this.mWriteType.isCache()) {
                try {
                    if (this.mCancel) {
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.cancel();
                        }
                    } else {
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.close();
                        }
                        canComplete = true;
                    }
                }
                catch (IOException ioe) {
                    if (this.mWriteType.isMustCache()) {
                        LOG.error(ioe.getMessage(), (Throwable)ioe);
                        throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType), ioe);
                    }
                    LOG.warn("Fail to cache for: ", (Throwable)ioe);
                }
            }
            if (canComplete.booleanValue()) {
                if (this.mWriteType.isAsync()) {
                    this.mTachyonFS.asyncCheckpoint(this.mFile.mFileId);
                }
                this.mTachyonFS.completeFile(this.mFile.mFileId);
            }
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.flush();
        }
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockId != -1L) {
            if (this.mCurrentBlockLeftByte != 0L) {
                throw new IOException("The current block still has space left, no need to get new block");
            }
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.mWriteType.isCache()) {
            this.mCurrentBlockId = this.mFile.getBlockIdBasedOnOffset(this.mCachedBytes);
            this.mCurrentBlockLeftByte = this.mBlockCapacityByte;
            this.mCurrentBlockOutStream = new BlockOutStream(this.mFile, this.mWriteType, (int)(this.mCachedBytes / this.mBlockCapacityByte));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mWriteType.isCache()) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    if (this.mCurrentBlockLeftByte == 0L) {
                        this.getNextBlock();
                    } else if (this.mCurrentBlockLeftByte < 0L || this.mCurrentBlockOutStream == null) {
                        throw new IOException("mCurrentBlockLeftByte " + this.mCurrentBlockLeftByte + " " + this.mCurrentBlockOutStream);
                    }
                    if (this.mCurrentBlockLeftByte >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        this.mCurrentBlockLeftByte -= (long)tLen;
                        this.mCachedBytes += (long)tLen;
                        tOff += tLen;
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)this.mCurrentBlockLeftByte);
                    tOff = (int)((long)tOff + this.mCurrentBlockLeftByte);
                    tLen = (int)((long)tLen - this.mCurrentBlockLeftByte);
                    this.mCachedBytes += this.mCurrentBlockLeftByte;
                    this.mCurrentBlockLeftByte = 0L;
                }
            }
            catch (IOException e) {
                if (this.mWriteType.isMustCache()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType), e);
                }
                LOG.warn("Fail to cache for: ", (Throwable)e);
            }
        }
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mWriteType.isCache()) {
            try {
                if (this.mCurrentBlockId == -1L || this.mCurrentBlockLeftByte == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
                --this.mCurrentBlockLeftByte;
                ++this.mCachedBytes;
            }
            catch (IOException e) {
                if (this.mWriteType.isMustCache()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new IOException("Fail to cache: " + (Object)((Object)this.mWriteType), e);
                }
                LOG.warn("Fail to cache for: ", (Throwable)e);
            }
        }
        if (this.mWriteType.isThrough()) {
            this.mCheckpointOutputStream.write(b);
        }
    }
}

