/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import tachyon.TachyonURI;
import tachyon.Version;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.examples.Utils;

public final class BasicNonByteBufferOperations
implements Callable<Boolean> {
    private final TachyonURI mMasterLocation;
    private final TachyonURI mFilePath;
    private final WriteType mWriteType;
    private final ReadType mReadType;
    private final boolean mDeleteIfExists;
    private final int mLength;

    public BasicNonByteBufferOperations(TachyonURI masterLocation, TachyonURI filePath, WriteType writeType, ReadType readType, boolean deleteIfExists, int length) {
        this.mMasterLocation = masterLocation;
        this.mFilePath = filePath;
        this.mWriteType = writeType;
        this.mReadType = readType;
        this.mDeleteIfExists = deleteIfExists;
        this.mLength = length;
    }

    @Override
    public Boolean call() throws Exception {
        TachyonFS client = TachyonFS.get(this.mMasterLocation);
        this.write(client, this.mFilePath, this.mWriteType, this.mDeleteIfExists, this.mLength);
        return this.read(client, this.mFilePath, this.mReadType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(TachyonFS client, TachyonURI filePath, WriteType writeType, boolean deleteIfExists, int length) throws IOException {
        TachyonFile file = this.getOrCreate(client, filePath, deleteIfExists);
        DataOutputStream os = new DataOutputStream(file.getOutStream(writeType));
        try {
            os.writeInt(length);
            for (int i = 0; i < length; ++i) {
                os.writeInt(i);
            }
        }
        finally {
            os.close();
        }
    }

    private TachyonFile getOrCreate(TachyonFS client, TachyonURI filePath, boolean deleteIfExists) throws IOException {
        TachyonFile file = client.getFile(filePath);
        if (file == null) {
            int fileId = client.createFile(filePath);
            file = client.getFile(fileId);
        } else if (deleteIfExists) {
            client.delete(new TachyonURI(file.getPath()), false);
            int fileId = client.createFile(filePath);
            file = client.getFile(fileId);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(TachyonFS client, TachyonURI filePath, ReadType readType) throws IOException {
        TachyonFile file = client.getFile(filePath);
        DataInputStream input = new DataInputStream(file.getInStream(readType));
        boolean passes = true;
        try {
            int length = input.readInt();
            for (int i = 0; i < length; ++i) {
                passes &= input.readInt() == i;
            }
        }
        finally {
            input.close();
        }
        return passes;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args.length > 6) {
            BasicNonByteBufferOperations.usage();
        }
        Utils.runExample(new BasicNonByteBufferOperations(new TachyonURI(args[0]), new TachyonURI(args[1]), Utils.option(args, 2, WriteType.MUST_CACHE), Utils.option(args, 3, ReadType.NO_CACHE), Utils.option(args, 4, true), Utils.option(args, 5, 20)));
    }

    private static void usage() {
        System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + BasicNonByteBufferOperations.class.getName() + " <master address> <file path> [write type] [read type] [delete file] [num writes]");
        System.exit(-1);
    }
}

