/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    public static void addS3Credentials(Configuration conf) {
        String secretKeyConf;
        String accessKeyConf = "fs.s3n.awsAccessKeyId";
        if (System.getProperty(accessKeyConf) != null && conf.get(accessKeyConf) == null) {
            conf.set(accessKeyConf, System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.s3n.awsSecretAccessKey") != null && conf.get(secretKeyConf) == null) {
            conf.set(secretKeyConf, System.getProperty(secretKeyConf));
        }
    }

    public static Path getHDFSPath(TachyonURI path, String ufsAddress) {
        if (path.isPathAbsolute()) {
            return new Path(ufsAddress + path.getPath());
        }
        return new Path(ufsAddress + "/" + path.getPath());
    }

    public static String getPathWithoutScheme(Path path) {
        return path.toUri().getPath();
    }

    public static String getTachyonFileName(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        while (path.contains(":")) {
            int index = path.indexOf(":");
            path = path.substring(index + 1);
        }
        while (!path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String toStringHadoopFileSplit(FileSplit fs) {
        String[] locs;
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopFileSplit: Path: ").append(fs.getPath());
        sb.append(" , Start: ").append(fs.getStart());
        sb.append(" , Length: ").append(fs.getLength());
        sb.append(" , Hosts: ");
        try {
            locs = fs.getLocations();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            locs = new String[]{};
        }
        for (String loc : locs) {
            sb.append(loc).append("; ");
        }
        return sb.toString();
    }

    public static String toStringHadoopFileStatus(FileStatus fs) {
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopFileStatus: Path: ").append(fs.getPath());
        sb.append(" , Length: ").append(fs.getLen());
        sb.append(" , IsDir: ").append(fs.isDir());
        sb.append(" , BlockReplication: ").append(fs.getReplication());
        sb.append(" , BlockSize: ").append(fs.getBlockSize());
        sb.append(" , ModificationTime: ").append(fs.getModificationTime());
        sb.append(" , AccessTime: ").append(fs.getAccessTime());
        sb.append(" , Permission: ").append(fs.getPermission());
        sb.append(" , Owner: ").append(fs.getOwner());
        sb.append(" , Group: ").append(fs.getGroup());
        return sb.toString();
    }

    public static String toStringHadoopInputSplit(InputSplit is) {
        StringBuilder sb = new StringBuilder("HadoopInputSplit: ");
        try {
            sb.append(" Length: ").append(is.getLength());
            sb.append(" , Locations: ");
            for (String loc : is.getLocations()) {
                sb.append(loc).append(" ; ");
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return sb.toString();
    }
}

