/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import tachyon.master.ImageWriter;
import tachyon.thrift.ClientFileInfo;

public abstract class Inode
extends ImageWriter
implements Comparable<Inode> {
    private final long mCreationTimeMs;
    protected final boolean mIsFolder;
    private int mId;
    private String mName;
    private int mParentId;
    private boolean mPinned = false;
    private long mLastModificationTimeMs;

    protected Inode(String name, int id, int parentId, boolean isFolder, long creationTimeMs) {
        this.mCreationTimeMs = creationTimeMs;
        this.mIsFolder = isFolder;
        this.mId = id;
        this.mName = name;
        this.mParentId = parentId;
        this.mLastModificationTimeMs = creationTimeMs;
    }

    @Override
    public synchronized int compareTo(Inode o) {
        return this.mId - o.mId;
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof Inode)) {
            return false;
        }
        return this.mId == ((Inode)o).mId;
    }

    public abstract ClientFileInfo generateClientFileInfo(String var1);

    public long getCreationTimeMs() {
        return this.mCreationTimeMs;
    }

    public synchronized int getId() {
        return this.mId;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized int getParentId() {
        return this.mParentId;
    }

    public synchronized boolean isPinned() {
        return this.mPinned;
    }

    public synchronized long getLastModificationTimeMs() {
        return this.mLastModificationTimeMs;
    }

    public synchronized int hashCode() {
        return this.mId;
    }

    public boolean isDirectory() {
        return this.mIsFolder;
    }

    public boolean isFile() {
        return !this.mIsFolder;
    }

    public synchronized void reverseId() {
        this.mId = -this.mId;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized void setParentId(int parentId) {
        this.mParentId = parentId;
    }

    public synchronized void setPinned(boolean pinned) {
        this.mPinned = pinned;
    }

    public synchronized void setLastModificationTimeMs(long lastModificationTimeMs) {
        this.mLastModificationTimeMs = lastModificationTimeMs;
    }

    public synchronized String toString() {
        return "Inode(" + "ID:" + this.mId + ", NAME:" + this.mName + ", PARENT_ID:" + this.mParentId + ", CREATION_TIME_MS:" + this.mCreationTimeMs + ", PINNED:" + this.mPinned + ", LAST_MODIFICATION_TIME_MS:" + this.mLastModificationTimeMs + ")";
    }
}

