/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tachyon.Pair;
import tachyon.conf.CommonConf;
import tachyon.io.Utils;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.ImageWriter;
import tachyon.thrift.TachyonException;

public class RawTables
extends ImageWriter {
    private Map<Integer, Pair<Integer, ByteBuffer>> mData = new HashMap<Integer, Pair<Integer, ByteBuffer>>();

    public synchronized boolean addRawTable(int tableId, int columns, ByteBuffer metadata) throws TachyonException {
        if (this.mData.containsKey(tableId)) {
            return false;
        }
        this.mData.put(tableId, new Pair<Integer, Object>(columns, null));
        this.updateMetadata(tableId, metadata);
        return true;
    }

    public synchronized boolean delete(int tableId) {
        this.mData.remove(tableId);
        return true;
    }

    public synchronized boolean exist(int inodeId) {
        return this.mData.containsKey(inodeId);
    }

    public synchronized int getColumns(int tableId) {
        Pair<Integer, ByteBuffer> data = this.mData.get(tableId);
        return null == data ? -1 : data.getFirst();
    }

    public synchronized ByteBuffer getMetadata(int tableId) {
        Pair<Integer, ByteBuffer> data = this.mData.get(tableId);
        if (null == data) {
            return null;
        }
        ByteBuffer ret = ByteBuffer.allocate(data.getSecond().capacity());
        ret.put(data.getSecond().array());
        ret.flip();
        return ret;
    }

    public synchronized Pair<Integer, ByteBuffer> getTableInfo(int tableId) {
        return this.mData.get(tableId);
    }

    void loadImage(ImageElement ele) throws IOException {
        List<Integer> ids = ele.get("ids", new TypeReference<List<Integer>>(){});
        List<Integer> columns = ele.get("columns", new TypeReference<List<Integer>>(){});
        List<ByteBuffer> data = ele.getByteBufferList("data");
        for (int k = 0; k < ids.size(); ++k) {
            try {
                if (this.addRawTable(ids.get(k), columns.get(k), data.get(k))) continue;
                throw new IOException("Failed to create raw table");
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
        }
    }

    public synchronized void updateMetadata(int tableId, ByteBuffer metadata) throws TachyonException {
        Pair<Integer, ByteBuffer> data = this.mData.get(tableId);
        if (null == data) {
            throw new TachyonException("The raw table " + tableId + " does not exist.");
        }
        if (metadata == null) {
            data.setSecond(ByteBuffer.allocate(0));
        } else {
            if (metadata.limit() - metadata.position() >= CommonConf.get().MAX_TABLE_METADATA_BYTE) {
                throw new TachyonException("Too big table metadata: " + metadata.toString());
            }
            ByteBuffer tMetadata = ByteBuffer.allocate(metadata.limit() - metadata.position());
            tMetadata.put(metadata.array(), metadata.position(), metadata.limit() - metadata.position());
            tMetadata.flip();
            data.setSecond(tMetadata);
        }
    }

    @Override
    public synchronized void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<Integer> columns = new ArrayList<Integer>();
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>();
        for (Map.Entry<Integer, Pair<Integer, ByteBuffer>> entry : this.mData.entrySet()) {
            ids.add(entry.getKey());
            columns.add(entry.getValue().getFirst());
            data.add(entry.getValue().getSecond());
        }
        ImageElement ele = new ImageElement(ImageElementType.RawTable).withParameter("ids", ids).withParameter("columns", columns).withParameter("data", Utils.byteBufferListToBase64(data));
        this.writeElement(objWriter, dos, ele);
    }
}

