/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import tachyon.UnderFileSystem;
import tachyon.thrift.InvalidPathException;

public final class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"");

    public static void changeLocalFilePermission(String filePath, String perms) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add(perms);
        File file = new File(filePath);
        commands.add(file.getAbsolutePath());
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            process.waitFor();
            CommonUtils.redirectIO(process);
            if (process.exitValue() != 0) {
                throw new IOException("Can not change the file " + file.getAbsolutePath() + " 's permission to be " + perms);
            }
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
    }

    private static void redirectIO(Process process) throws IOException {
        Closer closer = Closer.create();
        try {
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getInputStream())), (OutputStream)System.out);
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getErrorStream())), (OutputStream)System.err);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        CommonUtils.changeLocalFilePermission(filePath, "777");
    }

    public static void cleanDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.isDirect()) {
            Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
            cleaner.clean();
        }
    }

    public static String cleanPath(String path) throws InvalidPathException {
        CommonUtils.validatePath(path);
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)path));
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit() - buf.position());
        ret.put(buf.array(), buf.position(), buf.limit() - buf.position());
        ret.flip();
        return ret;
    }

    public static List<ByteBuffer> cloneByteBufferList(List<ByteBuffer> source) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(source.size());
        for (int k = 0; k < source.size(); ++k) {
            ret.add(CommonUtils.cloneByteBuffer(source.get(k)));
        }
        return ret;
    }

    public static String concat(Object ... args) {
        if (args.length == 0) {
            return "";
        }
        String retPath = args[0].toString();
        for (int k = 1; k < args.length; ++k) {
            while (retPath.endsWith("/")) {
                retPath = retPath.substring(0, retPath.length() - 1);
            }
            retPath = args[k].toString().startsWith("/") ? retPath + args[k].toString() : retPath + "/" + args[k].toString();
        }
        return retPath;
    }

    public static String convertByteArrayToStringWithoutEscape(byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = offset; i < length && i < data.length; ++i) {
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    public static String convertMsToClockTime(long Millis) {
        Preconditions.checkArgument((Millis >= 0L ? 1 : 0) != 0, (Object)"Negative values are not supported");
        long days = Millis / 86400000L;
        long hours = Millis % 86400000L / 3600000L;
        long mins = Millis % 3600000L / 60000L;
        long secs = Millis % 60000L / 1000L;
        return String.format("%d day(s), %d hour(s), %d minute(s), and %d second(s)", days, hours, mins, secs);
    }

    public static String convertMsToDate(long Millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS");
        return formatter.format(new Date(Millis));
    }

    public static String convertMsToShortClockTime(long Millis) {
        Preconditions.checkArgument((Millis >= 0L ? 1 : 0) != 0, (Object)"Negative values are not supported");
        long days = Millis / 86400000L;
        long hours = Millis % 86400000L / 3600000L;
        long mins = Millis % 3600000L / 60000L;
        long secs = Millis % 60000L / 1000L;
        return String.format("%d d, %d h, %d m, and %d s", days, hours, mins, secs);
    }

    public static String convertMsToSimpleDate(long Millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy");
        return formatter.format(new Date(Millis));
    }

    public static ByteBuffer generateNewByteBufferFromThriftRPCResults(ByteBuffer data) {
        ByteBuffer correctData = ByteBuffer.allocate(data.limit() - data.position());
        correctData.put(data);
        correctData.flip();
        return correctData;
    }

    public static long getBlockIdFromFileName(String name) {
        long fileId;
        try {
            fileId = Long.parseLong(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong file name: " + name);
        }
        return fileId;
    }

    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static long getCurrentNs() {
        return System.nanoTime();
    }

    public static long getMB(long bytes) {
        return bytes / 0x100000L;
    }

    public static String getName(String path) throws InvalidPathException {
        return FilenameUtils.getName((String)CommonUtils.cleanPath(path));
    }

    public static String getParent(String path) throws InvalidPathException {
        String cleanedPath = CommonUtils.cleanPath(path);
        String name = CommonUtils.getName(cleanedPath);
        String parent = cleanedPath.substring(0, cleanedPath.length() - name.length() - 1);
        if (parent.isEmpty()) {
            return "/";
        }
        return parent;
    }

    public static String[] getPathComponents(String path) throws InvalidPathException {
        if (CommonUtils.isRoot(path = CommonUtils.cleanPath(path))) {
            String[] ret = new String[]{""};
            return ret;
        }
        return path.split("/");
    }

    public static String getPathWithoutSchema(String path) {
        if (!path.contains("://")) {
            return path;
        }
        if (!(path = path.substring(path.indexOf("://") + 3)).contains("/")) {
            return "/";
        }
        return path.substring(path.indexOf("/"));
    }

    public static String getSizeFromBytes(long bytes) {
        double ret = bytes;
        if (ret <= 5120.0) {
            return String.format("%.2f B", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f KB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f MB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f GB", ret);
        }
        if ((ret /= 1024.0) <= 5120.0) {
            return String.format("%.2f TB", ret);
        }
        return String.format("%.2f PB", ret);
    }

    public static boolean isRoot(String path) throws InvalidPathException {
        return "/".equals(CommonUtils.cleanPath(path));
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < list.size(); ++k) {
            sb.append(list.get(k)).append(" ");
        }
        return sb.toString();
    }

    public static String parametersToString(Object ... objs) {
        StringBuilder sb = new StringBuilder("(");
        for (int k = 0; k < objs.length; ++k) {
            if (k != 0) {
                sb.append(", ");
            }
            sb.append(objs[k].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static InetSocketAddress parseInetSocketAddress(String address) throws IOException {
        if (address == null) {
            return null;
        }
        String[] strArr = address.split(":");
        if (strArr.length != 2) {
            throw new IOException("Invalid InetSocketAddress " + address);
        }
        return new InetSocketAddress(strArr[0], Integer.parseInt(strArr[1]));
    }

    public static long parseSpaceSize(String spaceSize) {
        int tIndex;
        double alpha = 1.0E-4;
        String ori = spaceSize;
        String end = "";
        for (tIndex = spaceSize.length() - 1; tIndex >= 0 && (spaceSize.charAt(tIndex) > '9' || spaceSize.charAt(tIndex) < '0'); --tIndex) {
            end = spaceSize.charAt(tIndex) + end;
        }
        spaceSize = spaceSize.substring(0, tIndex + 1);
        double ret = Double.parseDouble(spaceSize);
        if ((end = end.toLowerCase()).isEmpty() || end.equals("b")) {
            return (long)(ret + alpha);
        }
        if (end.equals("kb")) {
            return (long)(ret * 1024.0 + alpha);
        }
        if (end.equals("mb")) {
            return (long)(ret * 1048576.0 + alpha);
        }
        if (end.equals("gb")) {
            return (long)(ret * 1.073741824E9 + alpha);
        }
        if (end.equals("tb")) {
            return (long)(ret * 1.099511627776E12 + alpha);
        }
        if (end.equals("pb")) {
            BigDecimal pBDecimal = new BigDecimal(0x4000000000000L);
            return pBDecimal.multiply(BigDecimal.valueOf(ret)).longValue();
        }
        throw new IllegalArgumentException("Fail to parse " + ori + " as memory size");
    }

    public static void printByteBuffer(Logger LOG, ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < buf.limit() / 4; ++k) {
            sb.append(buf.getInt()).append(" ");
        }
        LOG.info(sb.toString());
    }

    public static void printTimeTakenMs(long startTimeMs, Logger logger, String message) {
        logger.info(message + " took " + (CommonUtils.getCurrentMs() - startTimeMs) + " ms.");
    }

    public static void printTimeTakenNs(long startTimeNs, Logger logger, String message) {
        logger.info(message + " took " + (CommonUtils.getCurrentNs() - startTimeNs) + " ns.");
    }

    public static void setLocalFileStickyBit(String file) {
        try {
            if (file.startsWith("/")) {
                Runtime.getRuntime().exec("chmod o+t " + file);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the file : " + file);
        }
    }

    public static void sleepMs(Logger logger, long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void temporaryLog(String msg) {
        LOG.info("Temporary Log ============================== " + msg);
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static void touch(String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        OutputStream os = ufs.create(path);
        os.close();
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path == null || path.isEmpty() || !path.startsWith("/") || path.contains(" ")) {
            throw new InvalidPathException("Path " + path + " is invalid.");
        }
    }
}

