/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.org.apache.thrift.transport.TNonblockingServerSocket;
import tachyon.thrift.NetAddress;

public final class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private NetworkUtils() {
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getByName(NetworkUtils.getLocalIpAddress()).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getLocalIpAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            LOG.debug("address: {} isLoopbackAddress: {}, with host {} {}", new Object[]{address, address.isLoopbackAddress(), address.getHostAddress(), address.getHostName()});
            if (address.isLoopbackAddress()) {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        address = addresses.nextElement();
                        if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                        return address.getHostAddress();
                    }
                }
                LOG.warn("Your hostname, " + InetAddress.getLocalHost().getHostName() + " resolves to" + " a loopback address: " + address.getHostAddress() + ", but we couldn't find any" + " external IP address!");
            }
            return address.getHostAddress();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static TachyonURI replaceHostName(TachyonURI path) throws UnknownHostException {
        if (path == null) {
            return null;
        }
        if (path.hasAuthority() && path.getPort() != -1) {
            String authority = NetworkUtils.resolveHostName(path.getHost());
            if (path.getPort() != -1) {
                authority = authority + ":" + path.getPort();
            }
            return new TachyonURI(path.getScheme(), authority, path.getPath());
        }
        return path;
    }

    public static String resolveHostName(String hostname) throws UnknownHostException {
        if (hostname == null || hostname.isEmpty()) {
            return null;
        }
        return InetAddress.getByName(hostname).getCanonicalHostName();
    }

    public static String getFqdnHost(InetSocketAddress addr) {
        return addr.getAddress().getCanonicalHostName();
    }

    public static String getFqdnHost(NetAddress addr) throws UnknownHostException {
        return NetworkUtils.resolveHostName(addr.getMHost());
    }

    public static int getPort(TNonblockingServerSocket thriftSocket) {
        return NetworkUtils.getSocket(thriftSocket).getLocalPort();
    }

    public static ServerSocket getSocket(TNonblockingServerSocket thriftSocket) {
        try {
            Field field = TNonblockingServerSocket.class.getDeclaredField("serverSocket_");
            field.setAccessible(true);
            return (ServerSocket)field.get(thriftSocket);
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

