/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

public final class UiFileInfo {
    public static final Ordering<UiFileInfo> PATH_STRING_COMPARE = Ordering.natural().onResultOf((Function)new Function<UiFileInfo, Comparable<String>>(){

        public Comparable<String> apply(UiFileInfo input) {
            return input.mAbsolutePath;
        }
    });
    private final int mId;
    private final int mDependencyId;
    private final String mName;
    private final String mAbsolutePath;
    private final String mCheckpointPath;
    private final long mBlockSizeBytes;
    private final long mSize;
    private final long mCreationTimeMs;
    private final long mLastModificationTimeMs;
    private final boolean mInMemory;
    private final int mInMemoryPercent;
    private final boolean mIsDirectory;
    private final boolean mIsPinned;
    private List<String> mFileLocations;

    public UiFileInfo(ClientFileInfo fileInfo) {
        this.mId = fileInfo.getId();
        this.mDependencyId = fileInfo.getDependencyId();
        this.mName = fileInfo.getName();
        this.mAbsolutePath = fileInfo.getPath();
        this.mCheckpointPath = fileInfo.getUfsPath();
        this.mBlockSizeBytes = fileInfo.getBlockSizeByte();
        this.mSize = fileInfo.getLength();
        this.mCreationTimeMs = fileInfo.getCreationTimeMs();
        this.mLastModificationTimeMs = fileInfo.getLastModificationTimeMs();
        this.mInMemory = 100 == fileInfo.inMemoryPercentage;
        this.mInMemoryPercent = fileInfo.getInMemoryPercentage();
        this.mIsDirectory = fileInfo.isFolder;
        this.mIsPinned = fileInfo.isPinned;
        this.mFileLocations = new ArrayList<String>();
    }

    public String getAbsolutePath() {
        return this.mAbsolutePath;
    }

    public String getBlockSizeBytes() {
        if (this.mIsDirectory) {
            return " ";
        }
        return CommonUtils.getSizeFromBytes(this.mBlockSizeBytes);
    }

    public String getCheckpointPath() {
        return this.mCheckpointPath;
    }

    public String getCreationTime() {
        return CommonUtils.convertMsToDate(this.mCreationTimeMs);
    }

    public String getModificationTime() {
        return CommonUtils.convertMsToDate(this.mLastModificationTimeMs);
    }

    public int getDependencyId() {
        return this.mDependencyId;
    }

    public List<String> getFileLocations() {
        return this.mFileLocations;
    }

    public int getId() {
        return this.mId;
    }

    public boolean getInMemory() {
        return this.mInMemory;
    }

    public int getInMemoryPercentage() {
        return this.mInMemoryPercent;
    }

    public boolean getIsDirectory() {
        return this.mIsDirectory;
    }

    public boolean getNeedPin() {
        return this.mIsPinned;
    }

    public String getName() {
        if ("/".equals(this.mAbsolutePath)) {
            return "root";
        }
        return this.mName;
    }

    public String getSize() {
        if (this.mIsDirectory) {
            return " ";
        }
        return CommonUtils.getSizeFromBytes(this.mSize);
    }

    public void setFileLocations(List<NetAddress> fileLocations) {
        for (NetAddress addr : fileLocations) {
            this.mFileLocations.add(addr.getMHost() + ":" + addr.getMPort());
        }
    }
}

