/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.master.BlockInfo;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.util.CommonUtils;
import tachyon.web.UiFileInfo;

public class WebInterfaceBrowseServlet
extends HttpServlet {
    private static final long serialVersionUID = 6121623049981468871L;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceBrowseServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void displayFile(TachyonURI path, HttpServletRequest request, long offset) throws FileDoesNotExistException, InvalidPathException, IOException {
        masterAddress = "tachyon://" + this.mMasterInfo.getMasterAddress().getHostName() + ":" + this.mMasterInfo.getMasterAddress().getPort();
        tachyonClient = TachyonFS.get(new TachyonURI(masterAddress));
        tFile = tachyonClient.getFile(path);
        fileData = null;
        if (tFile == null) {
            throw new FileDoesNotExistException(path.toString());
        }
        if (tFile.isComplete()) {
            is = tFile.getInStream(ReadType.NO_CACHE);
            try {
                len = (int)Math.min(5120L, tFile.length() - offset);
                data = new byte[len];
                skipped = is.skip(offset);
                if (skipped < 0L) {
                    fileData = "Unable to traverse to offset; is file empty?";
                }
                if (skipped < offset) {
                    fileData = "Unable to traverse to offset; is offset larger than the file?";
                }
                read = is.read(data, 0, len);
                if (read < 0) {
                    fileData = "Unable to read file";
                }
                fileData = CommonUtils.convertByteArrayToStringWithoutEscape(data, 0, read);
                if (fileData != null) ** GOTO lbl31
                fileData = "The requested file is not completely encoded in ascii";
            }
            finally {
                is.close();
            }
        } else {
            fileData = "The requested file is not complete yet.";
        }
lbl31:
        // 6 sources

        try {
            tachyonClient.close();
        }
        catch (IOException e) {
            WebInterfaceBrowseServlet.LOG.error(e.getMessage());
        }
        rawBlockList = this.mMasterInfo.getBlockList(path);
        uiBlockInfo = new ArrayList<UiBlockInfo>();
        for (BlockInfo blockInfo : rawBlockList) {
            uiBlockInfo.add(new UiBlockInfo(blockInfo));
        }
        request.setAttribute("fileBlocks", uiBlockInfo);
        request.setAttribute("fileData", (Object)fileData);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, UnknownHostException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("invalidPathError", (Object)"");
        List<ClientFileInfo> filesInfo = null;
        String requestPath = request.getParameter("path");
        if (requestPath == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        TachyonURI currentPath = new TachyonURI(requestPath);
        request.setAttribute("currentPath", (Object)currentPath.toString());
        request.setAttribute("viewingOffset", (Object)0);
        try {
            ClientFileInfo clientFileInfo = this.mMasterInfo.getClientFileInfo(currentPath);
            UiFileInfo currentFileInfo = new UiFileInfo(clientFileInfo);
            if (null == currentFileInfo.getAbsolutePath()) {
                throw new FileDoesNotExistException(currentPath.toString());
            }
            request.setAttribute("currentDirectory", (Object)currentFileInfo);
            request.setAttribute("blockSizeByte", (Object)currentFileInfo.getBlockSizeBytes());
            if (!currentFileInfo.getIsDirectory()) {
                String tmpParam = request.getParameter("offset");
                long offset = 0L;
                try {
                    if (tmpParam != null) {
                        offset = Long.valueOf(tmpParam);
                    }
                }
                catch (NumberFormatException nfe) {
                    offset = 0L;
                }
                if (offset < 0L) {
                    offset = 0L;
                } else if (offset > clientFileInfo.getLength()) {
                    offset = clientFileInfo.getLength();
                }
                this.displayFile(new TachyonURI(currentFileInfo.getAbsolutePath()), request, offset);
                request.setAttribute("viewingOffset", (Object)offset);
                this.getServletContext().getRequestDispatcher("/viewFile.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.setPathDirectories(currentPath, request);
            filesInfo = this.mMasterInfo.getFilesInfo(currentPath);
        }
        catch (FileDoesNotExistException fdne) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (InvalidPathException ipe) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IOException ie) {
            request.setAttribute("invalidPathError", (Object)("Error: File " + currentPath + " is not available " + ie.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ArrayList<UiFileInfo> fileInfos = new ArrayList<UiFileInfo>(filesInfo.size());
        for (ClientFileInfo fileInfo : filesInfo) {
            UiFileInfo toAdd = new UiFileInfo(fileInfo);
            try {
                if (!toAdd.getIsDirectory() && fileInfo.getLength() > 0L) {
                    toAdd.setFileLocations(this.mMasterInfo.getFileBlocks(toAdd.getId()).get(0).getLocations());
                }
            }
            catch (FileDoesNotExistException fdne) {
                request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
                this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            fileInfos.add(toAdd);
        }
        Collections.sort(fileInfos, UiFileInfo.PATH_STRING_COMPARE);
        request.setAttribute("nTotalFile", (Object)fileInfos.size());
        if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            int offset = Integer.parseInt(request.getParameter("offset"));
            int limit = Integer.parseInt(request.getParameter("limit"));
            List sub = fileInfos.subList(offset, offset + limit);
            request.setAttribute("fileInfos", sub);
        }
        catch (NumberFormatException nfe) {
            request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + nfe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IndexOutOfBoundsException iobe) {
            request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + iobe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IllegalArgumentException iae) {
            request.setAttribute("fatalError", (Object)iae.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void setPathDirectories(TachyonURI path, HttpServletRequest request) throws FileDoesNotExistException, InvalidPathException {
        if (path.isRoot()) {
            request.setAttribute("pathInfos", (Object)new UiFileInfo[0]);
            return;
        }
        String[] splitPath = CommonUtils.getPathComponents(path.toString());
        UiFileInfo[] pathInfos = new UiFileInfo[splitPath.length - 1];
        TachyonURI currentPath = new TachyonURI("/");
        pathInfos[0] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
        for (int i = 1; i < splitPath.length - 1; ++i) {
            currentPath = currentPath.join(splitPath[i]);
            pathInfos[i] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
        }
        request.setAttribute("pathInfos", (Object)pathInfos);
    }

    public static final class UiBlockInfo {
        private final long mId;
        private final long mBlockLength;
        private final boolean mInMemory;

        public UiBlockInfo(BlockInfo blockInfo) {
            this.mId = blockInfo.mBlockId;
            this.mBlockLength = blockInfo.mLength;
            this.mInMemory = blockInfo.isInMemory();
        }

        public long getBlockLength() {
            return this.mBlockLength;
        }

        public long getID() {
            return this.mId;
        }

        public boolean inMemory() {
            return this.mInMemory;
        }
    }
}

