/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.Constants;
import tachyon.Version;
import tachyon.master.DependencyVariables;
import tachyon.master.MasterInfo;
import tachyon.util.CommonUtils;

public class WebInterfaceGeneralServlet
extends HttpServlet {
    private static final long serialVersionUID = 2335205655766736309L;
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceGeneralServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DependencyVariables.VARIABLES.clear();
        for (String key : request.getParameterMap().keySet()) {
            String value;
            if (!key.startsWith("varName") || (value = request.getParameter("varVal" + key.substring(7))) == null) continue;
            DependencyVariables.VARIABLES.put(request.getParameter(key), value);
        }
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("uptime", (Object)CommonUtils.convertMsToClockTime(System.currentTimeMillis() - this.mMasterInfo.getStarttimeMs()));
        request.setAttribute("startTime", (Object)CommonUtils.convertMsToDate(this.mMasterInfo.getStarttimeMs()));
        request.setAttribute("version", (Object)Version.VERSION);
        request.setAttribute("liveWorkerNodes", (Object)Integer.toString(this.mMasterInfo.getWorkerCount()));
        request.setAttribute("capacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getCapacityBytes()));
        request.setAttribute("usedCapacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getUsedBytes()));
        request.setAttribute("freeCapacity", (Object)CommonUtils.getSizeFromBytes(this.mMasterInfo.getCapacityBytes() - this.mMasterInfo.getUsedBytes()));
        long sizeBytes = this.mMasterInfo.getUnderFsCapacityBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = this.mMasterInfo.getUnderFsUsedBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskUsedCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskUsedCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = this.mMasterInfo.getUnderFsFreeBytes();
        if (sizeBytes >= 0L) {
            request.setAttribute("diskFreeCapacity", (Object)CommonUtils.getSizeFromBytes(sizeBytes));
        } else {
            request.setAttribute("diskFreeCapacity", (Object)"UNKNOWN");
        }
        request.setAttribute("recomputeVariables", DependencyVariables.VARIABLES);
    }
}

