/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.eviction;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import tachyon.Pair;
import tachyon.master.BlockInfo;
import tachyon.worker.eviction.EvictStrategy;
import tachyon.worker.hierarchy.StorageDir;

public abstract class EvictLRUBase
implements EvictStrategy {
    private final boolean mLastTier;

    protected EvictLRUBase(boolean lastTier) {
        this.mLastTier = lastTier;
    }

    protected boolean blockEvictable(long blockId, Set<Integer> pinList) {
        return !this.mLastTier || !pinList.contains(BlockInfo.computeInodeId(blockId));
    }

    protected Pair<Long, Long> getLRUBlock(StorageDir curDir, Collection<Long> toEvictBlockIds, Set<Integer> pinList) {
        long blockId = -1L;
        long oldestTime = Long.MAX_VALUE;
        Set<Map.Entry<Long, Long>> accessTimes = curDir.getLastBlockAccessTimeMs();
        for (Map.Entry<Long, Long> accessTime : accessTimes) {
            if (toEvictBlockIds.contains(accessTime.getKey()) || accessTime.getValue() >= oldestTime || curDir.isBlockLocked(accessTime.getKey()) || !this.blockEvictable(accessTime.getKey(), pinList)) continue;
            oldestTime = accessTime.getValue();
            blockId = accessTime.getKey();
        }
        return new Pair<Long, Long>(blockId, oldestTime);
    }
}

