/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public final class BlockRequest {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;

    public BlockRequest(long blockId, long offset, long length) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public static final class Decoder
    extends ByteToMessageDecoder {
        private static final int MESSAGE_LENGTH = 26;

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 26) {
                return;
            }
            in.readShort();
            long blockId = in.readLong();
            long offset = in.readLong();
            long length = in.readLong();
            out.add(new BlockRequest(blockId, offset, length));
            ctx.channel().pipeline().remove((ChannelHandler)this);
        }
    }
}

