/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.netty;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.worker.BlockHandler;
import tachyon.worker.BlocksLocker;
import tachyon.worker.hierarchy.StorageDir;
import tachyon.worker.netty.BlockRequest;
import tachyon.worker.netty.BlockResponse;
import tachyon.worker.netty.ClosableResourceChannelListener;

@ChannelHandler.Sharable
public final class DataServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final BlocksLocker mLocker;

    public DataServerHandler(BlocksLocker locker) {
        this.mLocker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        BlockRequest req = (BlockRequest)msg;
        long blockId = req.getBlockId();
        long offset = req.getOffset();
        long len = req.getLength();
        int lockId = this.mLocker.getLockId();
        StorageDir storageDir = this.mLocker.lock(blockId, lockId);
        BlockHandler handler = null;
        try {
            this.validateInput(req);
            handler = storageDir.getBlockHandler(blockId);
            long fileLength = handler.getLength();
            this.validateBounds(req, fileLength);
            long readLength = this.returnLength(offset, len, fileLength);
            ChannelFuture future = ctx.writeAndFlush((Object)new BlockResponse(blockId, offset, readLength, handler));
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            future.addListener((GenericFutureListener)new ClosableResourceChannelListener(handler));
            storageDir.accessBlock(blockId);
            LOG.info("Response remote request by reading from {}, preparation done.", (Object)storageDir.getBlockFilePath(blockId));
        }
        catch (Exception e) {
            LOG.error("The file is not here : " + e.getMessage(), (Throwable)e);
            BlockResponse resp = BlockResponse.createErrorResponse(blockId);
            ChannelFuture future = ctx.writeAndFlush((Object)resp);
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            if (handler != null) {
                handler.close();
            }
        }
        finally {
            this.mLocker.unlock(blockId, lockId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("Exception thrown while processing request", cause);
        ctx.close();
    }

    private long returnLength(long offset, long len, long fileLength) {
        if (len == -1L) {
            return fileLength - offset;
        }
        return len;
    }

    private void validateBounds(BlockRequest req, long fileLength) {
        if (req.getOffset() > fileLength) {
            String msg = String.format("Offset(%d) is larger than file length(%d)", req.getOffset(), fileLength);
            throw new IllegalArgumentException(msg);
        }
        if (req.getLength() != -1L && req.getOffset() + req.getLength() > fileLength) {
            String msg = String.format("Offset(%d) plus length(%d) is larger than file length(%d)", req.getOffset(), req.getLength(), fileLength);
            throw new IllegalArgumentException(msg);
        }
    }

    private void validateInput(BlockRequest req) {
        if (req.getOffset() < 0L) {
            throw new IllegalArgumentException("Offset can not be negative: " + req.getOffset());
        }
        if (req.getLength() < 0L && req.getLength() != -1L) {
            String msg = "Length can not be negative except -1: " + req.getLength();
            throw new IllegalArgumentException(msg);
        }
    }
}

