/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.codegen;

import com.alibaba.citrus.generictype.codegen.MethodSignature;
import com.alibaba.citrus.generictype.codegen.asm.Type;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

public class TypeUtil {
    private static final Map<String, String> PRIMITIVE_DESCRIPTORS = CollectionUtil.createHashMap();

    public static String getInternalNameFromClassName(String className) {
        Assert.assertTrue(!StringUtil.isEmpty(className), "className is empty", new Object[0]);
        Assert.assertTrue(!className.startsWith("["), "%s is an array", className);
        Assert.assertTrue(!PRIMITIVE_DESCRIPTORS.containsKey(className), "%s is a primitive type", className);
        return className.replace('.', '/');
    }

    public static String getDescriptorFromClassName(String className) {
        Assert.assertTrue(!StringUtil.isEmpty(className), "className is empty", new Object[0]);
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        String descriptor = PRIMITIVE_DESCRIPTORS.get(className);
        if (descriptor != null) {
            return descriptor;
        }
        return "L" + className.replace('.', '/') + ";";
    }

    public static Type getTypeFromInternalName(String internalName) {
        return Type.getObjectType(internalName);
    }

    public static Type getTypeFromClassName(String className) {
        return Type.getType(TypeUtil.getDescriptorFromClassName(className));
    }

    public static Type getTypeFromClass(Class<?> type) {
        Assert.assertNotNull(type, "class", new Object[0]);
        return Type.getType(TypeUtil.getDescriptorFromClassName(type.getName()));
    }

    public static Type[] getTypes(Class<?>[] classes) {
        if (classes == null) {
            return new Type[0];
        }
        Type[] types = new Type[classes.length];
        for (int i = classes.length - 1; i >= 0; --i) {
            types[i] = TypeUtil.getTypeFromClass(classes[i]);
        }
        return types;
    }

    public static String[] getInternalNames(Type[] types) {
        if (types == null) {
            return new String[0];
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            Assert.assertTrue(type.getSort() == 10, "Type %s does not has internal name", type);
            names[i] = type.getInternalName();
        }
        return names;
    }

    public static MethodSignature getMethodSignature(Method method) {
        return new MethodSignature(method);
    }

    public static MethodSignature getMethodSignature(String name, Class<?> returnType, Class<?>[] parameterTypes) {
        return new MethodSignature(name, returnType, parameterTypes);
    }

    public static MethodSignature getConstructorSignature(Constructor<?> constructor) {
        return new MethodSignature(constructor);
    }

    public static MethodSignature getConstructorSignature(Class<?>[] parameterTypes) {
        return new MethodSignature("<init>", Void.TYPE, parameterTypes);
    }

    public static boolean testBits(int flags, int bits) {
        return (flags & bits) != 0;
    }

    static {
        PRIMITIVE_DESCRIPTORS.put("boolean", "Z");
        PRIMITIVE_DESCRIPTORS.put("short", "S");
        PRIMITIVE_DESCRIPTORS.put("int", "I");
        PRIMITIVE_DESCRIPTORS.put("long", "J");
        PRIMITIVE_DESCRIPTORS.put("float", "F");
        PRIMITIVE_DESCRIPTORS.put("double", "D");
        PRIMITIVE_DESCRIPTORS.put("char", "C");
        PRIMITIVE_DESCRIPTORS.put("byte", "B");
        PRIMITIVE_DESCRIPTORS.put("void", "V");
    }
}

