/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.condition;

import com.alibaba.citrus.expr.Expression;
import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.expr.ExpressionFactory;
import com.alibaba.citrus.expr.ExpressionParseException;
import com.alibaba.citrus.expr.jexl.JexlExpressionFactory;
import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractCondition;
import com.alibaba.citrus.service.form.support.AbstractConditionDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class JexlCondition
extends AbstractCondition {
    protected static final ExpressionFactory EXPRESSION_FACTORY = new JexlExpressionFactory();
    private String conditionString;
    private Expression condition;

    public JexlCondition(String condition) {
        this.conditionString = StringUtil.trimToNull(condition);
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.conditionString, "missing condition expression", new Object[0]);
        try {
            this.condition = EXPRESSION_FACTORY.createExpression(this.conditionString);
        }
        catch (ExpressionParseException e) {
            throw new IllegalArgumentException("Invalid if condition: \"" + StringEscapeUtil.escapeJava(this.conditionString) + "\"", e);
        }
    }

    @Override
    public boolean isSatisfied(final Validator.Context context) {
        TypeConverter converter = context.getField().getGroup().getForm().getTypeConverter();
        MessageContext expressionContext = new MessageContext(){

            @Override
            protected Object internalGet(String key) {
                return null;
            }

            @Override
            public ExpressionContext getParentContext() {
                return context.getMessageContext();
            }

            @Override
            protected void buildToString(ToStringBuilder sb) {
                sb.append("JexlConditionContext");
            }

            @Override
            protected void buildToString(ToStringBuilder.MapBuilder mb) {
            }
        };
        Object value = this.condition.evaluate(expressionContext);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)converter.convertIfNecessary(value, Boolean.class);
    }

    public static class DefinitionParser
    extends AbstractConditionDefinitionParser<JexlCondition> {
        @Override
        protected void doParseElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            builder.addConstructorArgValue((Object)element.getTextContent());
        }
    }
}

