/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.freemarker.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.freemarker.FreeMarkerEngine;
import com.alibaba.citrus.service.freemarker.impl.FreeMarkerConfigurationImpl;
import com.alibaba.citrus.service.freemarker.impl.log.LoggerHacker;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Template;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class FreeMarkerEngineImpl
extends AbstractService<FreeMarkerEngine>
implements FreeMarkerEngine,
ResourceLoaderAware,
ProductionModeAware {
    private final FreeMarkerConfigurationImpl configuration = new FreeMarkerConfigurationImpl(this.getLogger());

    public FreeMarkerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.configuration.setResourceLoader(loader);
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.configuration.setProductionMode(productionMode);
    }

    @Override
    protected void init() {
        this.configuration.init();
        this.getLogger().debug("FreeMarker Engine Configurations: {}", (Object)this.configuration);
    }

    @Override
    public String[] getDefaultExtensions() {
        return new String[]{"ftl"};
    }

    @Override
    public boolean exists(String templateName) {
        try {
            return this.configuration.getTemplateLoader().findTemplateSource(templateName) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getText(String templateName, TemplateContext context) throws TemplateException, IOException {
        StringWriter out = new StringWriter();
        this.render(templateName, context, out, null, null, null);
        return out.toString();
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, OutputStream ostream) throws TemplateException, IOException {
        this.render(templateName, context, null, ostream, null, null);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, Writer writer) throws TemplateException, IOException {
        this.render(templateName, context, writer, null, null, null);
    }

    @Override
    public String mergeTemplate(String templateName, Object context, String inputCharset) throws TemplateException, IOException {
        StringWriter out = new StringWriter();
        this.render(templateName, context, out, null, inputCharset, null);
        return out.toString();
    }

    @Override
    public void mergeTemplate(String templateName, Object context, OutputStream ostream, String inputCharset, String outputCharset) throws TemplateException, IOException {
        this.render(templateName, context, null, ostream, inputCharset, outputCharset);
    }

    @Override
    public void mergeTemplate(String templateName, Object context, Writer out, String inputCharset) throws TemplateException, IOException {
        this.render(templateName, context, out, null, inputCharset, null);
    }

    private void render(String templateName, Object context, Writer writer, OutputStream ostream, String inputCharset, String outputCharset) throws TemplateException, IOException {
        Locale locale = LocaleUtil.getContext().getLocale();
        if (StringUtil.isEmpty(inputCharset)) {
            inputCharset = this.configuration.getConfiguration().getDefaultEncoding();
        }
        inputCharset = StringUtil.defaultIfEmpty(inputCharset, "UTF-8");
        if (StringUtil.isEmpty(outputCharset)) {
            outputCharset = this.configuration.getConfiguration().getOutputEncoding();
        }
        outputCharset = StringUtil.defaultIfEmpty(outputCharset, "UTF-8");
        if (writer == null) {
            if (ostream == null) {
                throw new IllegalArgumentException("missing output writer");
            }
            writer = new OutputStreamWriter(ostream, outputCharset);
        }
        try {
            Template template = this.configuration.getConfiguration().getTemplate(templateName, locale, inputCharset);
            Environment env = template.createProcessingEnvironment(context, writer);
            env.setLocale(locale);
            env.setOutputEncoding(outputCharset);
            env.process();
        }
        catch (freemarker.template.TemplateException e) {
            this.error(templateName, e);
        }
        catch (ParseException e) {
            this.error(templateName, e);
        }
    }

    private void error(String templateName, Throwable e) {
        throw new TemplateException("Error rendering FreeMarker template: " + templateName, e);
    }

    static {
        String prefix = FreeMarkerEngine.class.getName();
        int index = prefix.indexOf("freemarker");
        if (index < 0) {
            index = prefix.length();
        }
        prefix = prefix.substring(0, index);
        LoggerHacker.hackLogger(prefix);
    }
}

