/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.builder.MailContent;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;

public abstract class AbstractContent
implements MailContent {
    private String id;
    private MailBuilder builder;
    private MailContent parentContent;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public MailBuilder getMailBuilder() {
        return this.getMailBuilder(true);
    }

    protected final MailBuilder getMailBuilder(boolean required) {
        if (this.builder != null) {
            return this.builder;
        }
        if (this.parentContent != null) {
            return this.parentContent.getMailBuilder();
        }
        if (required) {
            throw new IllegalArgumentException("no mailBuilder");
        }
        return null;
    }

    @Override
    public void setMailBuilder(MailBuilder builder) {
        this.builder = builder;
    }

    public MailContent getParentContent() {
        return this.parentContent;
    }

    @Override
    public void setParentContent(MailContent parentContent) {
        this.parentContent = parentContent;
    }

    @Override
    public final AbstractContent clone() {
        String className = this.getClass().getSimpleName();
        AbstractContent copy = Assert.assertNotNull(this.newInstance(), "%s.newInstance() returned null", className);
        Assert.assertTrue(copy.getClass().equals(this.getClass()), "%s.newInstance() returned an object of wrong class", className);
        this.copyTo(copy);
        copy.id = this.id;
        return copy;
    }

    protected abstract AbstractContent newInstance();

    protected void copyTo(AbstractContent copy) {
    }

    protected final <T> T getService(Class<T> serviceType, String defaultId, T defaultInstance) {
        MailService mailService;
        if (defaultInstance != null) {
            return defaultInstance;
        }
        MailBuilder builder = this.getMailBuilder(false);
        if (builder != null && (mailService = builder.getMailService()) != null) {
            return mailService.getService(serviceType, defaultId);
        }
        return null;
    }

    public final String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.append(this.getClass().getSimpleName());
        this.toString(buf);
        return buf.toString();
    }

    protected void toString(ToStringBuilder buf) {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        this.toString(mb);
        buf.append(mb);
    }

    protected void toString(ToStringBuilder.MapBuilder mb) {
    }
}

